/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class DivingHelmetItem
extends BaseArmorItem {
    public static final EquipmentSlot SLOT = EquipmentSlot.HEAD;

    public DivingHelmetItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc) {
        super(material, SLOT, properties, textureLoc);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44971_) {
            return 1;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = super.getAllEnchantments(stack);
        map.put(Enchantments.f_44971_, 1);
        return map;
    }

    public static boolean isWornBy(Entity entity, boolean fireproof) {
        ItemStack stack = DivingHelmetItem.getWornItem(entity);
        if (stack == null) {
            return false;
        }
        if (!stack.m_41720_().m_41475_() && fireproof) {
            return false;
        }
        return stack.m_41720_() instanceof DivingHelmetItem;
    }

    @Nullable
    public static ItemStack getWornItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity.m_6844_(SLOT);
    }

    @SubscribeEvent
    public static void breatheUnderwater(LivingEvent.LivingTickEvent event) {
        ServerPlayer sp;
        boolean lavaDiving;
        boolean drowning;
        LivingEntity entity = event.getEntity();
        Level world = entity.f_19853_;
        boolean second = world.m_46467_() % 20L == 0L;
        boolean bl = drowning = entity.m_20146_() == 0;
        if (world.f_46443_) {
            entity.getPersistentData().m_128473_("VisualBacktankAir");
        }
        if (!DivingHelmetItem.isWornBy((Entity)entity, lavaDiving = entity.m_20077_())) {
            return;
        }
        if (!entity.canDrownInFluidType(entity.getEyeInFluidType()) && !lavaDiving) {
            return;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return;
        }
        ItemStack backtank = BacktankUtil.get(entity);
        if (backtank.m_41619_()) {
            return;
        }
        if (!BacktankUtil.hasAirRemaining(backtank)) {
            return;
        }
        if (lavaDiving) {
            if (entity instanceof ServerPlayer) {
                sp = (ServerPlayer)entity;
                AllAdvancements.DIVING_SUIT_LAVA.awardTo((Player)sp);
            }
            if (!backtank.m_41720_().m_41475_()) {
                return;
            }
        }
        if (drowning) {
            entity.m_20301_(10);
        }
        if (world.f_46443_) {
            entity.getPersistentData().m_128405_("VisualBacktankAir", (int)BacktankUtil.getAir(backtank));
        }
        if (!second) {
            return;
        }
        BacktankUtil.consumeAir(entity, backtank, 1.0f);
        if (lavaDiving) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            sp = (ServerPlayer)entity;
            AllAdvancements.DIVING_SUIT.awardTo((Player)sp);
        }
        entity.m_20301_(Math.min(entity.m_6062_(), entity.m_20146_() + 10));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 30, 0, true, false, true));
    }
}

