/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.core;

import dev.compactmods.machines.api.room.upgrade.ILevelLoadedUpgradeListener;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.upgrade.RoomUpgradeManager;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="compactmachines")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onWorldLoaded(LevelEvent.Load evt) {
        ServerLevel sl;
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel && (sl = (ServerLevel)levelAccessor).m_46472_().equals(Dimension.COMPACT_DIMENSION)) {
            MinecraftServer serv = sl.m_7654_();
            WorldBorder owBorder = serv.m_129783_().m_6857_();
            WorldBorder cwBorder = sl.m_6857_();
            RoomUpgradeManager levelUpgrades = RoomUpgradeManager.get(sl);
            levelUpgrades.implementing(ILevelLoadedUpgradeListener.class).forEach(inst -> {
                ILevelLoadedUpgradeListener upg = (ILevelLoadedUpgradeListener)inst.upgrade();
                upg.onLevelLoaded(sl, inst.room());
            });
            Set listeners = owBorder.f_61905_.stream().filter(border -> border instanceof BorderChangeListener.DelegateBorderChangeListener).map(BorderChangeListener.DelegateBorderChangeListener.class::cast).filter(list -> list.f_61864_ == cwBorder).collect(Collectors.toSet());
            for (BorderChangeListener.DelegateBorderChangeListener listener : listeners) {
                owBorder.m_156096_((BorderChangeListener)listener);
            }
            cwBorder.m_61949_(0.0, 0.0);
            cwBorder.m_61917_(5.9999968E7);
            PacketDistributor.DIMENSION.with(() -> Dimension.COMPACT_DIMENSION).send((Packet)new ClientboundSetBorderSizePacket(cwBorder));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player.f_19853_.m_46472_().equals(Dimension.COMPACT_DIMENSION) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player;
        if (evt.getTo().equals(Dimension.COMPACT_DIMENSION) && (player = evt.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
        }
    }
}

