/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class ArrowItemCoFH
extends ArrowItem
implements ICoFHItem {
    protected final IArrowFactory<? extends AbstractArrow> factory;
    protected boolean infinitySupport = false;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";
    private static final AbstractProjectileDispenseBehavior DISPENSER_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        public Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            ArrowItemCoFH arrowItem = (ArrowItemCoFH)stackIn.m_41720_();
            AbstractArrow arrow = arrowItem.factory.createArrow(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_());
            arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            return arrow;
        }
    };

    public ArrowItemCoFH(IArrowFactory<? extends AbstractArrow> factory, Item.Properties builder) {
        super(builder);
        this.factory = factory;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ArrowItemCoFH setInfinitySupport(boolean infinitySupport) {
        this.infinitySupport = infinitySupport;
        return this;
    }

    public AbstractArrow m_6394_(Level worldIn, ItemStack stack, LivingEntity shooter) {
        return this.factory.createArrow(worldIn, shooter);
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return this.infinitySupport && Utils.getItemEnchantmentLevel(Enchantments.f_44952_, bow) > 0 || super.isInfinite(stack, bow, player);
    }

    @Override
    public ArrowItemCoFH setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public ArrowItemCoFH setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public ArrowItemCoFH setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }

    public static interface IArrowFactory<T extends AbstractArrow> {
        public T createArrow(Level var1, LivingEntity var2);

        public T createArrow(Level var1, double var2, double var4, double var6);
    }
}

