/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.entity.IOnPlaced;
import cofh.lib.util.Utils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ChestBoatCoFH
extends ChestBoat
implements IOnPlaced {
    protected ListTag enchantments = new ListTag();

    public ChestBoatCoFH(EntityType<? extends Boat> type, Level worldIn) {
        super(type, worldIn);
    }

    public ChestBoatCoFH(Supplier<EntityType<? extends Boat>> type, Level worldIn, double posX, double posY, double posZ) {
        this(type.get(), worldIn);
        this.m_6034_(posX, posY, posZ);
        this.f_19854_ = posX;
        this.f_19855_ = posY;
        this.f_19856_ = posZ;
    }

    @Override
    public ChestBoatCoFH onPlaced(ItemStack stack) {
        this.enchantments = stack.m_41785_();
        return this;
    }

    protected float getHoldingMod(Map<Enchantment, Integer> enchantmentMap) {
        int holding = enchantmentMap.getOrDefault(Utils.getEnchantment("cofh_core", "holding"), 0);
        return 1.0f + (float)holding / 2.0f;
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        if (!this.enchantments.isEmpty()) {
            stack.m_41700_("Enchantments", (Tag)this.enchantments);
        }
        return stack;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.enchantments = compound.m_128437_("Enchantments", 10);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Enchantments", (Tag)this.enchantments);
    }

    public void m_213560_(DamageSource source) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack stack = this.createItemStackTag(this.m_142340_());
            this.m_19983_(stack);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

