/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.enchantment;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public abstract class EnchantmentCoFH
extends Enchantment {
    protected boolean enable = true;
    protected boolean allowGenerateInLoot = true;
    protected boolean allowOnBooks = true;
    protected boolean allowVillagerTrade = true;
    protected boolean treasureEnchantment = false;
    protected int maxLevel = 1;

    protected EnchantmentCoFH(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot[] slots) {
        super(rarityIn, typeIn, slots);
    }

    public EnchantmentCoFH setEnable(boolean enable) {
        this.enable = enable;
        this.f_44673_ = enable ? this.m_44704_() : "enchantment.cofh_core.disabled";
        return this;
    }

    public EnchantmentCoFH setTreasureEnchantment(boolean treasureEnchantment) {
        this.treasureEnchantment = treasureEnchantment;
        return this;
    }

    public EnchantmentCoFH setAllowOnBooks(boolean allowOnBooks) {
        this.allowOnBooks = allowOnBooks;
        return this;
    }

    public EnchantmentCoFH setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public int m_6175_(int level) {
        return this.enable ? this.maxDelegate(level) : -1;
    }

    protected int maxDelegate(int level) {
        return this.m_6183_(level) + 5;
    }

    public int m_6586_() {
        return this.maxLevel;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.enable && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.enable && this.allowOnBooks;
    }

    public boolean m_6592_() {
        return this.enable && this.allowGenerateInLoot;
    }

    public boolean m_6594_() {
        return this.enable && this.allowVillagerTrade;
    }

    public boolean m_6591_() {
        return this.treasureEnchantment;
    }
}

