/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api.addons.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.addons.registry.AddonRegistry;
import com.smashingmods.chemlib.api.addons.registry.ModTracker;
import com.smashingmods.chemlib.common.blocks.ChemicalLiquidBlock;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.registry.ChemicalRegistry;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class CompoundRegistration {
    static void registerCompounds(AddonRegistry pRegisters, JsonObject pCompoundsJson) {
        for (JsonElement jsonElement : pCompoundsJson.getAsJsonArray("compounds")) {
            JsonObject object = jsonElement.getAsJsonObject();
            String compoundName = object.get("name").getAsString();
            MatterState matterState = MatterState.valueOf(object.get("matter_state").getAsString().toUpperCase());
            String description = object.has("description") ? object.get("description").getAsString() : "";
            String color = object.get("color").getAsString();
            JsonArray components = object.getAsJsonArray("components");
            LinkedHashMap<String, Integer> componentMap = new LinkedHashMap<String, Integer>();
            for (JsonElement component : components) {
                JsonObject componentObject = component.getAsJsonObject();
                String componentName = componentObject.get("name").getAsString();
                int count = componentObject.has("count") ? componentObject.get("count").getAsInt() : 1;
                componentMap.put(componentName, count);
            }
            if (!ModTracker.compoundNotExist(compoundName)) continue;
            RegistryObject registryObject = pRegisters.COMPOUNDS.register(compoundName, () -> new CompoundItem(compoundName, matterState, componentMap, description, color, ChemicalRegistry.mobEffectsFactory(object), pRegisters.getCompoundsTab()));
            switch (matterState) {
                case SOLID: {
                    boolean hasItem = object.get("has_item").getAsBoolean();
                    if (hasItem) break;
                    String registryName = String.format("%s_%s", registryObject.getId().m_135815_(), ChemicalItemType.COMPOUND.m_7912_());
                    pRegisters.COMPOUND_DUSTS.register(registryName, () -> new ChemicalItem(registryObject.getId(), ChemicalItemType.COMPOUND, new Item.Properties().m_41491_(pRegisters.getCompoundsTab())));
                    break;
                }
                case LIQUID: 
                case GAS: {
                    boolean hasFluid;
                    boolean bl = hasFluid = object.has("has_fluid") && object.get("has_fluid").getAsBoolean();
                    if (hasFluid) break;
                    JsonObject properties = object.get("fluid_properties").getAsJsonObject();
                    int slopeFindDistance = properties.has("slope_find_distance") ? properties.get("slope_find_distance").getAsInt() : 4;
                    int decreasePerBlock = properties.has("decrease_per_block") ? properties.get("decrease_per_block").getAsInt() : 1;
                    switch (matterState) {
                        case LIQUID: 
                        case GAS: {
                            CompoundRegistration.registerFluid(pRegisters, compoundName, ChemicalRegistry.fluidTypePropertiesFactory(properties, pRegisters.getModID(), compoundName), (int)Long.parseLong(color, 16), slopeFindDistance, decreasePerBlock);
                        }
                    }
                }
            }
            ModTracker.addCompound(new ResourceLocation(pRegisters.getModID(), compoundName));
        }
    }

    static void registerFluid(AddonRegistry pRegisters, String pName, FluidType.Properties pFluidProperties, final int pColor, int pSlopeFindDistance, int pDecreasePerBlock) {
        var ref = new Object(){
            ForgeFlowingFluid.Properties properties = null;
        };
        RegistryObject fluidType = pRegisters.FLUID_TYPES.register(pName, () -> new FluidType(pFluidProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return new ResourceLocation("block/water_still");
                    }

                    public ResourceLocation getFlowingTexture() {
                        return new ResourceLocation("block/water_flow");
                    }

                    public ResourceLocation getOverlayTexture() {
                        return new ResourceLocation("block/water_overlay");
                    }

                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return new ResourceLocation("minecraft", "textures/misc/underwater.png");
                    }

                    public int getTintColor() {
                        return pColor;
                    }

                    public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                        return pColor;
                    }
                });
            }
        });
        RegistryObject fluidSource = pRegisters.FLUIDS.register(String.format("%s_fluid", pName), () -> new ForgeFlowingFluid.Source(ref.properties));
        RegistryObject fluidFlowing = pRegisters.FLUIDS.register(String.format("%s_flowing", pName), () -> new ForgeFlowingFluid.Flowing(ref.properties));
        RegistryObject liquidBlock = pRegisters.LIQUID_BLOCKS.register(pName, () -> new ChemicalLiquidBlock((Supplier<? extends FlowingFluid>)fluidSource, pName));
        RegistryObject bucket = pRegisters.BUCKETS.register(String.format("%s_bucket", pName), () -> new BucketItem((Supplier)fluidSource, new Item.Properties().m_41491_(pRegisters.getBucketsTab()).m_41487_(1)));
        ref.properties = new ForgeFlowingFluid.Properties((Supplier)fluidType, (Supplier)fluidSource, (Supplier)fluidFlowing).slopeFindDistance(pSlopeFindDistance).levelDecreasePerBlock(pDecreasePerBlock).block((Supplier)liquidBlock).bucket((Supplier)bucket);
    }
}

