/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.WhitelistBlacklistSideButton;
import com.ultramega.cabletiers.blockentity.TieredDestructorBlockEntity;
import com.ultramega.cabletiers.container.TieredDestructorContainerMenu;
import com.ultramega.cabletiers.gui.TieredScreen;
import com.ultramega.cabletiers.node.TieredDestructorNetworkNode;
import com.ultramega.cabletiers.util.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class TieredDestructorScreen
extends TieredScreen<TieredDestructorBlockEntity, TieredDestructorContainerMenu, TieredDestructorNetworkNode> {
    public TieredDestructorScreen(TieredDestructorContainerMenu container, Inventory inventory, Component title) {
        super(container, 211, 119 + 18 * MathUtil.ceilDiv(9 * container.getTier().getSlotsMultiplier(), 9), inventory, title);
    }

    public void onPostInit(int x, int y) {
        this.addSideButton((SideButton)new RedstoneModeSideButton((BaseScreen)this, TieredDestructorBlockEntity.REDSTONE_MODE));
        this.addSideButton((SideButton)new TypeSideButton((BaseScreen)this, TieredDestructorBlockEntity.TYPE));
        this.addSideButton((SideButton)new WhitelistBlacklistSideButton((BaseScreen)this, TieredDestructorBlockEntity.WHITELIST_BLACKLIST));
        this.addSideButton((SideButton)new ExactModeSideButton((BaseScreen)this, TieredDestructorBlockEntity.COMPARE));
        this.addSideButton(new TieredDestructorPickupSideButton(this));
    }

    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("cabletiers", "gui/" + this.getTier().getName() + "_exporter_importer_destructor.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 7, 24 + 18 * MathUtil.ceilDiv(9 * this.getTier().getSlotsMultiplier(), 9), I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
    }

    private static class TieredDestructorPickupSideButton
    extends SideButton {
        private TieredDestructorPickupSideButton(BaseScreen<?> screen) {
            super(screen);
        }

        protected void renderButtonIcon(PoseStack poseStack, int x, int y) {
            this.screen.m_93228_(poseStack, x, y, 64 + (Boolean.TRUE.equals(TieredDestructorBlockEntity.PICKUP.getValue()) ? 0 : 16), 0, 16, 16);
        }

        public String getTooltip() {
            return I18n.m_118938_((String)"sidebutton.refinedstorage.destructor.pickup", (Object[])new Object[0]) + "\n" + ChatFormatting.GRAY + I18n.m_118938_((String)(Boolean.TRUE.equals(TieredDestructorBlockEntity.PICKUP.getValue()) ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        }

        public void m_5691_() {
            BlockEntitySynchronizationManager.setParameter(TieredDestructorBlockEntity.PICKUP, (Object)((Boolean)TieredDestructorBlockEntity.PICKUP.getValue() == false ? 1 : 0));
        }
    }
}

