/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.CableTiers;
import com.ultramega.cabletiers.blockentity.TieredBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredConstructorBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredDestructorBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredDiskManipulatorBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredExporterBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredImporterBlockEntity;
import com.ultramega.cabletiers.blockentity.TieredRequesterBlockEntity;
import com.ultramega.cabletiers.blocks.TieredConstructorBlock;
import com.ultramega.cabletiers.blocks.TieredDestructorBlock;
import com.ultramega.cabletiers.blocks.TieredDiskManipulatorBlock;
import com.ultramega.cabletiers.blocks.TieredExporterBlock;
import com.ultramega.cabletiers.blocks.TieredImporterBlock;
import com.ultramega.cabletiers.blocks.TieredRequesterBlock;
import com.ultramega.cabletiers.container.TieredConstructorContainerMenu;
import com.ultramega.cabletiers.container.TieredContainerMenu;
import com.ultramega.cabletiers.container.TieredDestructorContainerMenu;
import com.ultramega.cabletiers.container.TieredDiskManipulatorContainer;
import com.ultramega.cabletiers.container.TieredExporterContainerMenu;
import com.ultramega.cabletiers.container.TieredImporterContainerMenu;
import com.ultramega.cabletiers.container.TieredRequesterContainer;
import com.ultramega.cabletiers.node.TieredConstructorNetworkNode;
import com.ultramega.cabletiers.node.TieredDestructorNetworkNode;
import com.ultramega.cabletiers.node.TieredDiskManipulatorNetworkNode;
import com.ultramega.cabletiers.node.TieredExporterNetworkNode;
import com.ultramega.cabletiers.node.TieredImporterNetworkNode;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import com.ultramega.cabletiers.node.TieredRequesterNetworkNode;
import com.ultramega.cabletiers.registry.RegistryHandler;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="cabletiers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ContentType<B extends BaseBlock, T extends TieredBlockEntity<N>, C extends TieredContainerMenu<T, N>, N extends TieredNetworkNode<N>> {
    public static final ContentType<TieredImporterBlock, TieredImporterBlockEntity, TieredImporterContainerMenu, TieredImporterNetworkNode> IMPORTER = new ContentType<TieredImporterBlock, TieredImporterBlockEntity, TieredImporterContainerMenu, TieredImporterNetworkNode>("importer", TieredImporterBlock::new, TieredImporterBlockEntity::new, TieredImporterContainerMenu::new, TieredImporterNetworkNode::new);
    public static final ContentType<TieredExporterBlock, TieredExporterBlockEntity, TieredExporterContainerMenu, TieredExporterNetworkNode> EXPORTER = new ContentType<TieredExporterBlock, TieredExporterBlockEntity, TieredExporterContainerMenu, TieredExporterNetworkNode>("exporter", TieredExporterBlock::new, TieredExporterBlockEntity::new, TieredExporterContainerMenu::new, TieredExporterNetworkNode::new);
    public static final ContentType<TieredConstructorBlock, TieredConstructorBlockEntity, TieredConstructorContainerMenu, TieredConstructorNetworkNode> CONSTRUCTOR = new ContentType<TieredConstructorBlock, TieredConstructorBlockEntity, TieredConstructorContainerMenu, TieredConstructorNetworkNode>("constructor", TieredConstructorBlock::new, TieredConstructorBlockEntity::new, TieredConstructorContainerMenu::new, TieredConstructorNetworkNode::new);
    public static final ContentType<TieredDestructorBlock, TieredDestructorBlockEntity, TieredDestructorContainerMenu, TieredDestructorNetworkNode> DESTRUCTOR = new ContentType<TieredDestructorBlock, TieredDestructorBlockEntity, TieredDestructorContainerMenu, TieredDestructorNetworkNode>("destructor", TieredDestructorBlock::new, TieredDestructorBlockEntity::new, TieredDestructorContainerMenu::new, TieredDestructorNetworkNode::new);
    public static final ContentType<TieredDiskManipulatorBlock, TieredDiskManipulatorBlockEntity, TieredDiskManipulatorContainer, TieredDiskManipulatorNetworkNode> DISK_MANIPULATOR = new ContentType<TieredDiskManipulatorBlock, TieredDiskManipulatorBlockEntity, TieredDiskManipulatorContainer, TieredDiskManipulatorNetworkNode>("disk_manipulator", TieredDiskManipulatorBlock::new, TieredDiskManipulatorBlockEntity::new, TieredDiskManipulatorContainer::new, TieredDiskManipulatorNetworkNode::new);
    public static final ContentType<TieredRequesterBlock, TieredRequesterBlockEntity, TieredRequesterContainer, TieredRequesterNetworkNode> REQUESTER = new ContentType<TieredRequesterBlock, TieredRequesterBlockEntity, TieredRequesterContainer, TieredRequesterNetworkNode>("requester", TieredRequesterBlock::new, TieredRequesterBlockEntity::new, TieredRequesterContainer::new, TieredRequesterNetworkNode::new);
    public static final ContentType<?, ?, ?, ?>[] CONTENT_TYPES = new ContentType[]{EXPORTER, IMPORTER, CONSTRUCTOR, DESTRUCTOR, DISK_MANIPULATOR, REQUESTER};
    private final Map<CableTier, RegistryObject<B>> blocks = new EnumMap<CableTier, RegistryObject<B>>(CableTier.class);
    private final Map<CableTier, RegistryObject<Item>> items = new EnumMap<CableTier, RegistryObject<Item>>(CableTier.class);
    private final Map<CableTier, RegistryObject<BlockEntityType<T>>> blockEntityTypes = new EnumMap<CableTier, RegistryObject<BlockEntityType<T>>>(CableTier.class);
    private final Map<CableTier, RegistryObject<MenuType<C>>> containerTypes = new EnumMap<CableTier, RegistryObject<MenuType<C>>>(CableTier.class);
    private final String name;
    private final Function<CableTier, B> blockFactory;
    private final BlockEntityFactory<T> blockEntityFactory;
    private final MenuFactory<T, C> containerFactory;
    private final NetworkNodeFactory<N> networkNodeFactory;
    private final Map<CableTier, Class<N>> networkNodeClassTypes = new EnumMap<CableTier, Class<N>>(CableTier.class);
    public static final CreativeModeTab CABLE_TIERS = new CreativeModeTab("cabletiers"){

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cabletiers:creative_importer")));
        }
    };

    private ContentType(String name, Function<CableTier, B> blockFactory, BlockEntityFactory<T> blockEntityFactory, MenuFactory<T, C> containerFactory, NetworkNodeFactory<N> networkNodeFactory) {
        this.name = name;
        this.blockFactory = blockFactory;
        this.blockEntityFactory = blockEntityFactory;
        this.containerFactory = containerFactory;
        this.networkNodeFactory = networkNodeFactory;
    }

    public static void init() {
        for (ContentType<?, ?, ?, ?> type : CONTENT_TYPES) {
            type.initContent();
        }
    }

    @SubscribeEvent
    public static void registerWithRS(FMLCommonSetupEvent event) {
        for (ContentType<?, ?, ?, ?> type : CONTENT_TYPES) {
            type.registerContent();
        }
    }

    public B getBlock(CableTier tier) {
        return (B)((BaseBlock)this.blocks.get((Object)tier).get());
    }

    public Item getItem(CableTier tier) {
        return (Item)this.items.get((Object)tier).get();
    }

    public BlockEntityType<T> getBlockEntityType(CableTier tier) {
        return (BlockEntityType)this.blockEntityTypes.get((Object)tier).get();
    }

    public MenuType<C> getContainerType(CableTier tier) {
        return (MenuType)this.containerTypes.get((Object)tier).get();
    }

    public Class<N> getNetworkNodeClass(CableTier tier) {
        return this.networkNodeClassTypes.get((Object)tier);
    }

    public String getName(CableTier tier) {
        return tier.getName() + "_" + this.name;
    }

    public ResourceLocation getId(CableTier tier) {
        return new ResourceLocation("cabletiers", this.getName(tier));
    }

    public C createContainer(int windowId, Player player, T tile) {
        return (C)((Object)((TieredContainerMenu)((Object)this.containerFactory.create(windowId, player, tile))));
    }

    public N createNetworkNode(Level level, BlockPos pos, CableTier tier) {
        TieredNetworkNode networkNode = (TieredNetworkNode)((Object)this.networkNodeFactory.create(level, pos, tier));
        this.networkNodeClassTypes.put(tier, ((Object)((Object)networkNode)).getClass());
        return (N)((Object)networkNode);
    }

    private void initContent() {
        for (CableTier tier : CableTier.VALUES) {
            String id = this.getName(tier);
            this.blocks.put(tier, RegistryHandler.BLOCKS.register(id, () -> (BaseBlock)this.blockFactory.apply(tier)));
            this.items.put(tier, (RegistryObject<Item>)RegistryHandler.ITEMS.register(id, () -> new BaseBlockItem(this.getBlock(tier), new Item.Properties().m_41491_(CABLE_TIERS))));
            this.blockEntityTypes.put(tier, RegistryHandler.BLOCK_ENTITY_TYPES.register(id, () -> BlockEntityType.Builder.m_155273_((pos, state) -> (TieredBlockEntity)((Object)((Object)((Object)this.blockEntityFactory.create(tier, pos, state)))), (Block[])new Block[]{this.getBlock(tier)}).m_58966_(null)));
            this.containerTypes.put(tier, RegistryHandler.CONTAINER_TYPES.register(id, () -> IForgeMenuType.create((windowId, inv, data) -> {
                BlockPos pos = data.m_130135_();
                BlockEntity tile = inv.f_35978_.m_20193_().m_7702_(pos);
                if (tile == null) {
                    CableTiers.LOGGER.error("Expected tile entity of type " + id + ", but found none");
                    return null;
                }
                BlockEntityType<T> blockEntityType = this.getBlockEntityType(tier);
                if (tile.m_58903_() != blockEntityType) {
                    CableTiers.LOGGER.error("Wrong type of block entity, expected " + blockEntityType.toString() + ", but got " + tile.m_58903_().toString());
                    return null;
                }
                return this.createContainer(windowId, inv.f_35978_, (TieredBlockEntity)tile);
            })));
        }
    }

    private void registerContent() {
        for (CableTier tier : CableTier.VALUES) {
            API.instance().getNetworkNodeRegistry().add(this.getId(tier), (tag, level, pos) -> {
                N node = this.createNetworkNode(level, pos, tier);
                node.read(tag);
                return node;
            });
            ((TieredBlockEntity)this.getBlockEntityType(tier).m_155264_(BlockPos.f_121853_, null)).getDataManager().getParameters().forEach(BlockEntitySynchronizationManager::registerParameter);
        }
    }

    @FunctionalInterface
    private static interface BlockEntityFactory<T extends BaseBlockEntity> {
        public T create(CableTier var1, BlockPos var2, BlockState var3);
    }

    @FunctionalInterface
    private static interface MenuFactory<T extends BaseBlockEntity, C extends Container> {
        public C create(int var1, Player var2, T var3);
    }

    @FunctionalInterface
    private static interface NetworkNodeFactory<N> {
        public N create(Level var1, BlockPos var2, CableTier var3);
    }
}

