/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.registry;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class ImmutableOrderedRegistry<T> {
    private final ImmutableBiMap<ResourceLocation, T> backingMap;
    private final ImmutableList<T> orderedValues;

    ImmutableOrderedRegistry(Map<ResourceLocation, T> backingMap, List<T> orderedValues) {
        this.backingMap = ImmutableBiMap.copyOf(backingMap);
        this.orderedValues = ImmutableList.copyOf(orderedValues);
    }

    @Nullable
    public T get(ResourceLocation key) {
        return (T)this.backingMap.get((Object)key);
    }

    public boolean contains(ResourceLocation key) {
        return this.backingMap.containsKey((Object)key);
    }

    public ImmutableList<T> getValuesInOrder() {
        return this.orderedValues;
    }

    public Stream<T> values() {
        return this.orderedValues.stream();
    }

    public Iterator<T> iterator() {
        return this.orderedValues.iterator();
    }

    public void forEach(Consumer<? super T> action) {
        this.orderedValues.forEach(action);
    }

    public Spliterator<T> spliterator() {
        return this.orderedValues.spliterator();
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.backingMap.inverse().get(value);
    }
}

