/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRotateMirror {
    private Operation operation;

    public PacketRotateMirror() {
    }

    public PacketRotateMirror(@Nullable Operation operation) {
        this.operation = operation;
    }

    public static void encode(PacketRotateMirror msg, FriendlyByteBuf buffer) {
        boolean hasOperation = msg.operation != null;
        buffer.writeBoolean(hasOperation);
        if (hasOperation) {
            buffer.writeInt(msg.operation.ordinal());
        }
    }

    public static PacketRotateMirror decode(FriendlyByteBuf buffer) {
        return new PacketRotateMirror(buffer.readBoolean() ? Operation.values()[buffer.readInt()] : null);
    }

    public static enum Operation {
        ROTATE,
        MIRROR;

    }

    public static class Handler {
        public static void handle(PacketRotateMirror msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Operation operation;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = AbstractGadget.getGadget((Player)player);
                Operation operation2 = msg.operation != null ? msg.operation : (operation = player.m_6144_() ? Operation.MIRROR : Operation.ROTATE);
                if (operation == Operation.MIRROR) {
                    ((AbstractGadget)stack.m_41720_()).onMirror(stack, (Player)player);
                } else {
                    ((AbstractGadget)stack.m_41720_()).onRotate(stack, (Player)player);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

