/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.PasteContainerCapabilityProvider;
import com.direwolf20.buildinggadgets.common.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ConstructionPasteContainer
extends Item {
    private static final ResourceLocation LEVEL = new ResourceLocation("level");
    private final IntSupplier maxCapacity;
    private final boolean isCreative;

    public ConstructionPasteContainer(boolean isCreative, IntSupplier maxCapacity) {
        super(OurItems.nonStackableItemProperties());
        this.isCreative = isCreative;
        this.maxCapacity = maxCapacity;
    }

    public ConstructionPasteContainer(boolean isCreative) {
        this(isCreative, () -> Integer.MAX_VALUE);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PasteContainerCapabilityProvider(stack);
    }

    public void setPasteCount(ItemStack stack, int amount) {
        if (this.isCreative) {
            return;
        }
        stack.m_41784_().m_128405_("amount", amount);
    }

    public int getPasteCount(ItemStack stack) {
        if (this.isCreative) {
            return Integer.MAX_VALUE;
        }
        return !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_("amount");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        player.m_6672_(hand);
        Inventory inv = player.m_150109_();
        if (!world.f_46443_) {
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.m_8020_(i);
                if (!(itemStack.m_41720_() instanceof ConstructionPaste)) continue;
                InventoryHelper.addPasteToContainer(player, itemStack);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        MutableComponent key = this.isCreative ? TooltipTranslation.PASTECONTAINER_CREATIVE_AMOUNT.componentTranslation(new Object[0]) : TooltipTranslation.PASTECONTAINER_AMOUNT.componentTranslation(this.getPasteCount(stack), this.getMaxCapacity());
        list.add((Component)key.m_6270_(Styles.WHITE));
    }

    public static void setPasteAmount(ItemStack stack, int amount) {
        Item item = stack.m_41720_();
        if (item instanceof ConstructionPasteContainer) {
            ((ConstructionPasteContainer)item).setPasteCount(stack, amount);
        } else {
            BuildingGadgets.LOG.warn("Potential abuse of ConstructionPasteContainer#setPasteAmount(ItemStack, int) where the given ItemStack does not contain a ConstructionPasteContainer.");
        }
    }

    public static int getPasteAmount(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ConstructionPasteContainer) {
            return ((ConstructionPasteContainer)item).getPasteCount(stack);
        }
        BuildingGadgets.LOG.warn("Potential abuse of ConstructionPasteContainer#getPasteAmount(ItemStack) where the given ItemStack does not contain a ConstructionPasteContainer.");
        return 0;
    }

    public int getMaxCapacity() {
        return this.isCreative ? Integer.MAX_VALUE : this.maxCapacity.getAsInt();
    }

    public boolean isCreative() {
        return this.isCreative;
    }
}

