/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.ItemFluidContainer;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public record ForgeItemFluidContainer(ItemFluidContainer container, ItemStack itemStack) implements IFluidHandlerItem
{
    @NotNull
    public ItemStack getContainer() {
        return this.container.getContainerItem();
    }

    public int getTanks() {
        return this.container.getSize();
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return new ForgeFluidHolder(this.container.getFluids().get(i)).getFluidStack();
    }

    public int getTankCapacity(int i) {
        return (int)this.container.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.getFluidInTank(i).isFluidEqual(fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        long filled = this.container.insertFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate());
        this.container.update(this.itemStack);
        return (int)filled;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidStack drained = new ForgeFluidHolder(this.container.extractFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate())).getFluidStack();
        this.container.update(this.itemStack);
        return drained;
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        FluidHolder fluid = this.container.getFluids().get(0).copyHolder();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(i);
        this.container.update(this.itemStack);
        return new ForgeFluidHolder(this.container.extractFluid(fluid, fluidAction.simulate())).getFluidStack();
    }
}

