/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.util.records.SizeI;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class ImageRepeatable
extends Pane {
    public static final int MINECRAFT_DEFAULT_TEXTURE_IMAGE_SIZE = 256;
    protected ResourceLocation resourceLocation;
    protected int u = 0;
    protected int v = 0;
    protected int uWidth = 0;
    protected int vHeight = 0;
    protected int uRepeat = 0;
    protected int vRepeat = 0;
    protected int repeatWidth = 0;
    protected int repeatHeight = 0;
    protected int fileWidth = 256;
    protected int fileHeight = 256;

    public ImageRepeatable() {
    }

    public ImageRepeatable(PaneParams params) {
        super(params);
        this.resourceLocation = params.getResource("source", this::loadMapDimensions);
        params.applyShorthand("textureoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("texturesize", Parsers.INT, 2, a -> {
            this.uWidth = (Integer)a.get(0);
            this.vHeight = (Integer)a.get(1);
        });
        params.applyShorthand("repeatoffset", Parsers.INT, 2, a -> {
            this.uRepeat = (Integer)a.get(0);
            this.vRepeat = (Integer)a.get(1);
        });
        params.applyShorthand("repeatsize", Parsers.INT, 2, a -> {
            this.repeatWidth = (Integer)a.get(0);
            this.repeatHeight = (Integer)a.get(1);
        });
    }

    private void loadMapDimensions(ResourceLocation rl) {
        SizeI dimensions = Image.getImageDimensions(rl);
        this.fileWidth = dimensions.width();
        this.fileHeight = dimensions.height();
    }

    public void setImageLoc(String source) {
        this.setImageLoc(source != null ? new ResourceLocation(source) : null);
    }

    public void setImageLoc(ResourceLocation loc) {
        this.resourceLocation = loc;
        this.loadMapDimensions(loc);
    }

    public void setImageSize(int u, int v, int uWidth, int vHeight, int uRepeat, int vRepeat, int repeatWidth, int repeatHeight) {
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.uRepeat = uRepeat;
        this.vRepeat = vRepeat;
        this.repeatWidth = repeatWidth;
        this.repeatHeight = repeatHeight;
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        ImageRepeatable.blitRepeatable(ms, this.resourceLocation, this.x, this.y, this.width, this.height, this.u, this.v, this.uWidth == 0 ? this.fileWidth : this.uWidth, this.vHeight == 0 ? this.fileHeight : this.vHeight, this.fileWidth, this.fileHeight, this.uRepeat, this.vRepeat, this.repeatWidth, this.repeatHeight);
        RenderSystem.m_69461_();
    }
}

