/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.phosphophyllite.data.DataLoader;
import net.roguelogix.phosphophyllite.networking.SimplePhosChannel;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.robn.ROBNObject;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import org.apache.commons.lang3.NotImplementedException;

public class ReactorModeratorRegistry {
    private static final HashMap<Block, ModeratorProperties> registry = new HashMap();
    private static final DataLoader<ReactorModeratorJsonData> dataLoader = new DataLoader(ReactorModeratorJsonData.class);

    public static boolean isBlockAllowed(Block block) {
        return registry.containsKey(block);
    }

    public static ModeratorProperties blockModeratorProperties(Block block) {
        return registry.get(block);
    }

    public static void loadRegistry() {
        BiggerReactors.LOGGER.info("Loading reactor moderators");
        registry.clear();
        List data = dataLoader.loadAll(new ResourceLocation("biggerreactors:ebcr/moderators"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " moderator data entries");
        for (ReactorModeratorJsonData moderatorData : data) {
            ModeratorProperties properties = new ModeratorProperties(moderatorData.absorption, moderatorData.efficiency, moderatorData.moderation, moderatorData.conductivity);
            switch (moderatorData.type) {
                case "tag": {
                    Optional blockTagOptional = Registry.f_122824_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)moderatorData.location));
                    blockTagOptional.ifPresent(holders -> holders.forEach(blockHolder -> {
                        Block element = (Block)blockHolder.m_203334_();
                        registry.put(element, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + ForgeRegistries.BLOCKS.getKey((Object)element));
                    }));
                    break;
                }
                case "registry": {
                    if (!ForgeRegistries.BLOCKS.containsKey(moderatorData.location)) break;
                    registry.put((Block)ForgeRegistries.BLOCKS.getValue(moderatorData.location), properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                    break;
                }
                case "fluidtag": {
                    Optional fluidTagOptional = Registry.f_122822_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)moderatorData.location));
                    fluidTagOptional.ifPresent(holders -> holders.forEach(fluidHolder -> {
                        Fluid element = (Fluid)fluidHolder.m_203334_();
                        Block elementBlock = element.m_76145_().m_76188_().m_60734_();
                        registry.put(elementBlock, properties);
                        BiggerReactors.LOGGER.debug("Loaded moderator " + ForgeRegistries.FLUIDS.getKey((Object)element));
                    }));
                    break;
                }
                case "fluid": {
                    if (!ForgeRegistries.FLUIDS.containsKey(moderatorData.location)) break;
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(moderatorData.location);
                    assert (fluid != null);
                    Block block = fluid.m_76145_().m_76188_().m_60734_();
                    registry.put(block, properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + moderatorData.location);
                }
            }
        }
        BiggerReactors.LOGGER.info("Loaded " + registry.size() + " moderator entries");
    }

    public static class ModeratorProperties
    implements IModeratorProperties,
    ROBNObject {
        public static final ModeratorProperties EMPTY_MODERATOR = new ModeratorProperties(0.0, 0.0, 1.0, 0.0);
        public final double absorption;
        public final double heatEfficiency;
        public final double moderation;
        public final double heatConductivity;

        public ModeratorProperties(double absorption, double heatEfficiency, double moderation, double heatConductivity) {
            this.absorption = absorption;
            this.heatEfficiency = heatEfficiency;
            this.moderation = moderation;
            this.heatConductivity = heatConductivity;
        }

        @Override
        public double absorption() {
            return this.absorption;
        }

        @Override
        public double heatEfficiency() {
            return this.heatEfficiency;
        }

        @Override
        public double moderation() {
            return this.moderation;
        }

        @Override
        public double heatConductivity() {
            return this.heatConductivity;
        }
    }

    private static class ReactorModeratorJsonData {
        @DataLoader.Values(value={"tag", "registry", "fluidtag", "fluid"})
        String type;
        ResourceLocation location;
        @DataLoader.Range(value="[0,1]")
        double absorption;
        @DataLoader.Range(value="[0,1]")
        double efficiency;
        @DataLoader.Range(value="[1,)")
        double moderation;
        @DataLoader.Range(value="[0,)")
        double conductivity;

        private ReactorModeratorJsonData() {
        }
    }

    public static class Client {
        private static final SimplePhosChannel CHANNEL = new SimplePhosChannel(new ResourceLocation("biggerreactors", "moderator_sync_channel"), "0", Client::readSync);
        private static final ObjectOpenHashSet<Block> moderatorBlocks = new ObjectOpenHashSet();
        private static final Object2ObjectOpenHashMap<Block, ModeratorProperties> moderatorProperties = new Object2ObjectOpenHashMap();

        @OnModLoad(required=true)
        private static void onModLoad() {
            MinecraftForge.EVENT_BUS.addListener(Client::datapackEvent);
            if (FMLEnvironment.dist.isClient()) {
                MinecraftForge.EVENT_BUS.addListener(Client::toolTipEvent);
            }
        }

        public static void datapackEvent(OnDatapackSyncEvent e) {
            ServerPlayer player = e.getPlayer();
            if (player == null) {
                return;
            }
            if (BiggerReactors.LOG_DEBUG) {
                BiggerReactors.LOGGER.debug("Sending moderator list to player: " + player);
            }
            CHANNEL.sendToPlayer(player, Client.writeSync());
        }

        private static PhosphophylliteCompound writeSync() {
            ObjectArrayList list = new ObjectArrayList();
            ObjectArrayList propertiesList = new ObjectArrayList();
            for (Map.Entry<Block, ModeratorProperties> value : registry.entrySet()) {
                ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)value.getKey());
                if (location == null) continue;
                list.add((Object)location.toString());
                DoubleArrayList properties = new DoubleArrayList();
                properties.add(value.getValue().absorption);
                properties.add(value.getValue().heatEfficiency);
                properties.add(value.getValue().moderation);
                properties.add(value.getValue().heatConductivity);
                propertiesList.add((Object)properties);
            }
            PhosphophylliteCompound compound = new PhosphophylliteCompound();
            compound.put("list", (List)list);
            compound.put("propertiesList", (List)propertiesList);
            return compound;
        }

        private static void readSync(PhosphophylliteCompound compound) {
            moderatorBlocks.clear();
            List list = compound.getList("list");
            List propertiesList = compound.getList("propertiesList");
            if (BiggerReactors.LOG_DEBUG) {
                BiggerReactors.LOGGER.debug("Received moderator list from server with length of " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                String blockLocation = (String)list.get(i);
                DoubleArrayList properties = (DoubleArrayList)propertiesList.get(i);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockLocation));
                if (block == null) {
                    return;
                }
                if (BiggerReactors.LOG_DEBUG) {
                    BiggerReactors.LOGGER.debug("Block " + block + " added as moderator on client");
                }
                moderatorBlocks.add((Object)block);
                moderatorProperties.put((Object)block, (Object)new ModeratorProperties(properties.getDouble(0), properties.getDouble(1), properties.getDouble(2), properties.getDouble(3)));
            }
        }

        public static void toolTipEvent(ItemTooltipEvent event) {
            Item item = event.getItemStack().m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (!moderatorBlocks.contains((Object)blockItem.m_40614_())) {
                    return;
                }
            } else if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                Block fluidBlock = bucketItem.getFluid().m_76145_().m_76188_().m_60734_();
                if (fluidBlock.m_49966_().m_60795_() || !moderatorBlocks.contains((Object)fluidBlock)) {
                    return;
                }
            } else {
                return;
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_ || Config.CONFIG.AlwaysShowTooltips) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.biggerreactors.is_a_moderator"));
            }
        }

        public static void forEach(BiConsumer<Block, IModeratorProperties> consumer) {
            moderatorProperties.forEach(consumer);
        }
    }

    public static interface IModeratorProperties
    extends ROBNObject {
        public double absorption();

        public double heatEfficiency();

        public double moderation();

        public double heatConductivity();

        default public Map<String, Object> toROBNMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("absorption", this.absorption());
            map.put("heatEfficiency", this.heatEfficiency());
            map.put("moderation", this.moderation());
            map.put("heatConductivity", this.heatConductivity());
            return map;
        }

        default public void fromROBNMap(Map<String, Object> map) {
            throw new NotImplementedException("");
        }
    }
}

