/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.blocks.materials.MaterialBlock;
import net.roguelogix.biggerreactors.items.ingots.BlutoniumIngot;
import net.roguelogix.biggerreactors.items.ingots.CyaniteIngot;
import net.roguelogix.biggerreactors.items.ingots.UraniumIngot;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorAccessPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorAccessPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorAccessPortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorAccessPortTile
extends ReactorBaseTile
implements IItemHandler,
MenuProvider,
IHasUpdatableState<ReactorAccessPortState>,
IAssemblyAttemptedTile,
IOnDisassemblyTile {
    @RegisterTile(value="reactor_access_port")
    public static final BlockEntityType.BlockEntitySupplier<ReactorAccessPortTile> SUPPLIER = new RegisterTile.Producer(ReactorAccessPortTile::new);
    private static final TagKey<Item> uraniumIngotTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge:ingots/uranium"));
    private static final TagKey<Item> uraniumBlockTag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge:storage_blocks/uranium"));
    public static final int FUEL_SLOT = 0;
    public static final int WASTE_SLOT = 1;
    public static final int FUEL_INSERT_SLOT = 2;
    private ReactorAccessPort.PortDirection direction = ReactorAccessPort.PortDirection.INLET;
    private boolean fuelMode = false;
    LazyOptional<IItemHandler> itemStackHandler = LazyOptional.of(() -> this);
    Direction itemOutputDirection;
    boolean connected;
    LazyOptional<IItemHandler> itemOutput = LazyOptional.empty();
    public final ReactorAccessPortState reactorAccessPortState = new ReactorAccessPortState(this);

    public ReactorAccessPortTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean isInlet() {
        return this.direction == ReactorAccessPort.PortDirection.INLET;
    }

    public void setDirection(ReactorAccessPort.PortDirection direction) {
        this.direction = direction;
        this.m_6596_();
    }

    protected void readNBT(CompoundTag compound) {
        if (compound.m_128441_("direction")) {
            this.direction = ReactorAccessPort.PortDirection.valueOf(compound.m_128461_("direction"));
        }
        if (compound.m_128441_("fuelMode")) {
            this.fuelMode = compound.m_128471_("fuelMode");
        }
    }

    protected CompoundTag writeNBT() {
        CompoundTag NBT = new CompoundTag();
        NBT.m_128359_("direction", String.valueOf((Object)this.direction));
        NBT.m_128379_("fuelMode", this.fuelMode);
        return NBT;
    }

    @Nonnull
    public DebugInfo getDebugInfo() {
        return super.getDebugInfo().add("PortDirection: " + this.direction);
    }

    public void onAssemblyAttempted() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)), 3);
        this.itemOutputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.itemOutputDirection = null;
        this.neighborChanged();
    }

    protected <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler.cast();
        }
        return super.capability(cap, side);
    }

    public int getSlots() {
        return 3;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.nullableController() == null) {
            return ItemStack.f_41583_;
        }
        IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
        if (reactorSim == null) {
            return ItemStack.f_41583_;
        }
        if (slot == 1) {
            long availableIngots = reactorSim.fuelTank().waste() / Config.CONFIG.Reactor.FuelMBPerIngot;
            return new ItemStack((ItemLike)CyaniteIngot.INSTANCE, (int)availableIngots);
        }
        if (slot == 0) {
            long availableIngots = reactorSim.fuelTank().fuel() / Config.CONFIG.Reactor.FuelMBPerIngot;
            return new ItemStack((ItemLike)UraniumIngot.INSTANCE, (int)availableIngots);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        long canAccept;
        long maxAcceptable;
        if (!this.isInlet() || this.nullableController() == null || slot != 2) {
            return stack;
        }
        if ((stack = stack.m_41777_()).m_41720_().m_204114_().m_203656_(uraniumIngotTag) || stack.m_41720_().m_204114_().m_203656_(uraniumIngotTag) || stack.m_41720_() == BlutoniumIngot.INSTANCE) {
            maxAcceptable = ((ReactorMultiblockController)this.controller()).refuel((long)stack.m_41613_() * Config.CONFIG.Reactor.FuelMBPerIngot, true);
            canAccept = maxAcceptable - maxAcceptable % Config.CONFIG.Reactor.FuelMBPerIngot;
            ((ReactorMultiblockController)this.controller()).refuel(canAccept, simulate);
            if (canAccept > 0L) {
                stack.m_41764_(stack.m_41613_() - (int)(canAccept / Config.CONFIG.Reactor.FuelMBPerIngot));
            }
        }
        if (stack.m_41720_().m_204114_().m_203656_(uraniumBlockTag) || stack.m_41720_().m_204114_().m_203656_(uraniumBlockTag) || stack.m_41720_() == MaterialBlock.BLUTONIUM.m_5456_()) {
            maxAcceptable = ((ReactorMultiblockController)this.controller()).refuel((long)stack.m_41613_() * (Config.CONFIG.Reactor.FuelMBPerIngot * 9L), true);
            canAccept = maxAcceptable - maxAcceptable % (Config.CONFIG.Reactor.FuelMBPerIngot * 9L);
            ((ReactorMultiblockController)this.controller()).refuel(canAccept, simulate);
            if (canAccept > 0L) {
                stack.m_41764_(stack.m_41613_() - (int)(canAccept / (Config.CONFIG.Reactor.FuelMBPerIngot * 9L)));
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isInlet() || this.nullableController() == null || slot == 2) {
            return ItemStack.f_41583_;
        }
        if (slot == 1 && !this.fuelMode) {
            long maxExtractable = ((ReactorMultiblockController)this.controller()).extractWaste((long)amount * Config.CONFIG.Reactor.FuelMBPerIngot, true);
            long toExtracted = maxExtractable - maxExtractable % Config.CONFIG.Reactor.FuelMBPerIngot;
            long extracted = ((ReactorMultiblockController)this.controller()).extractWaste(toExtracted, simulate);
            return new ItemStack((ItemLike)CyaniteIngot.INSTANCE, (int)Math.min((long)amount, extracted / Config.CONFIG.Reactor.FuelMBPerIngot));
        }
        if (slot == 0 && this.fuelMode) {
            long maxExtractable = ((ReactorMultiblockController)this.controller()).extractFuel((long)amount * Config.CONFIG.Reactor.FuelMBPerIngot, true);
            long toExtracted = maxExtractable - maxExtractable % Config.CONFIG.Reactor.FuelMBPerIngot;
            long extracted = ((ReactorMultiblockController)this.controller()).extractFuel(toExtracted, simulate);
            return new ItemStack((ItemLike)UraniumIngot.INSTANCE, (int)Math.min((long)amount, extracted / Config.CONFIG.Reactor.FuelMBPerIngot));
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        if (this.nullableController() == null) {
            return 0;
        }
        IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
        if (reactorSim == null) {
            return 0;
        }
        return (int)(reactorSim.fuelTank().capacity() / Config.CONFIG.Reactor.FuelMBPerIngot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 2) {
            return stack.m_41720_().m_204114_().m_203656_(uraniumIngotTag) || stack.m_41720_() == BlutoniumIngot.INSTANCE || stack.m_41720_().m_204114_().m_203656_(uraniumBlockTag) || stack.m_41720_() == MaterialBlock.BLUTONIUM.m_5456_();
        }
        if (slot == 0) {
            return stack.m_41720_() == UraniumIngot.INSTANCE;
        }
        return stack.m_41720_() == CyaniteIngot.INSTANCE;
    }

    public int pushWaste(int waste, boolean simulated) {
        if (this.itemOutput.isPresent()) {
            ItemStack remainingStack;
            ItemStack toInsertStack;
            IItemHandler output = (IItemHandler)this.itemOutput.orElse((Object)EmptyHandler.INSTANCE);
            waste = (int)((long)waste / Config.CONFIG.Reactor.FuelMBPerIngot);
            int wasteHandled = 0;
            for (int i = 0; i < output.getSlots() && waste != 0; waste -= toInsertStack.m_41613_() - remainingStack.m_41613_(), ++i) {
                toInsertStack = new ItemStack((ItemLike)CyaniteIngot.INSTANCE, waste);
                remainingStack = output.insertItem(i, toInsertStack, simulated);
                wasteHandled += toInsertStack.m_41613_() - remainingStack.m_41613_();
            }
            return (int)((long)wasteHandled * Config.CONFIG.Reactor.FuelMBPerIngot);
        }
        return 0;
    }

    public void ejectWaste() {
        ((ReactorMultiblockController)this.controller()).extractWaste(this.pushWaste((int)((ReactorMultiblockController)this.controller()).extractWaste(Integer.MAX_VALUE, true), false), false);
    }

    public int pushFuel(int fuel, boolean simulated) {
        if (this.itemOutput.isPresent()) {
            ItemStack remainingStack;
            ItemStack toInsertStack;
            IItemHandler output = (IItemHandler)this.itemOutput.orElse((Object)EmptyHandler.INSTANCE);
            fuel = (int)((long)fuel / Config.CONFIG.Reactor.FuelMBPerIngot);
            int fuelHandled = 0;
            for (int i = 0; i < output.getSlots() && fuel != 0; fuel -= toInsertStack.m_41613_() - remainingStack.m_41613_(), ++i) {
                toInsertStack = new ItemStack((ItemLike)UraniumIngot.INSTANCE, fuel);
                remainingStack = output.insertItem(i, toInsertStack, simulated);
                fuelHandled += toInsertStack.m_41613_() - remainingStack.m_41613_();
            }
            return (int)((long)fuelHandled * Config.CONFIG.Reactor.FuelMBPerIngot);
        }
        return 0;
    }

    public void ejectFuel() {
        ((ReactorMultiblockController)this.controller()).extractFuel(this.pushFuel((int)((ReactorMultiblockController)this.controller()).extractFuel(Integer.MAX_VALUE, true), false), false);
    }

    public void neighborChanged() {
        this.itemOutput = LazyOptional.empty();
        if (this.itemOutputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.itemOutputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.itemOutput = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.itemOutputDirection.m_122424_());
        this.connected = this.itemOutput.isPresent();
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (this.nullableController() == null) {
            return;
        }
        if (requestName.equals("setDirection")) {
            this.setDirection((Integer)requestData != 0 ? ReactorAccessPort.PortDirection.OUTLET : ReactorAccessPort.PortDirection.INLET);
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)));
            return;
        }
        if (requestName.equals("setFuelMode")) {
            this.fuelMode = (Integer)requestData != 0;
            return;
        }
        if (requestName.equals("ejectWaste")) {
            if (this.fuelMode) {
                this.ejectFuel();
            } else {
                this.ejectWaste();
            }
            return;
        }
        super.runRequest(requestName, requestData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)ReactorAccessPort.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ReactorAccessPortContainer(windowId, this.f_58858_, player);
    }

    public ReactorAccessPortState getState() {
        this.updateState();
        return this.reactorAccessPortState;
    }

    public void updateState() {
        this.reactorAccessPortState.direction = this.direction == ReactorAccessPort.PortDirection.INLET;
        this.reactorAccessPortState.fuelMode = this.fuelMode;
    }
}

