/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.client.deps.jei.classic.reactor;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorTerminal;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;

public class FluidModeratorCategory
implements IRecipeCategory<Recipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation UID = new ResourceLocation("biggerreactors", "classic/reactor_moderator_fluid");
    public static final RecipeType<Recipe> RECIPE_TYPE = new RecipeType(UID, Recipe.class);

    public FluidModeratorCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ReactorTerminal.INSTANCE));
        this.background = guiHelper.createDrawable(new ResourceLocation("biggerreactors", "textures/jei/common.png"), 0, 0, 144, 46);
    }

    public RecipeType<Recipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.biggerreactors.classic.reactor_moderator_fluid");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 15);
        slot.addFluidStack(recipe.getInput().getRawFluid(), 1000L);
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Component[] info = new Component[]{Component.m_237110_((String)"jei.biggerreactors.classic.reactor_moderator_moderation", (Object[])new Object[]{recipe.getModeratorProperties().moderation()}), Component.m_237110_((String)"jei.biggerreactors.classic.reactor_moderator_absorption", (Object[])new Object[]{recipe.getModeratorProperties().absorption()}), Component.m_237110_((String)"jei.biggerreactors.classic.reactor_moderator_conductivity", (Object[])new Object[]{recipe.getModeratorProperties().heatConductivity()}), Component.m_237110_((String)"jei.biggerreactors.classic.reactor_moderator_efficiency", (Object[])new Object[]{recipe.getModeratorProperties().heatEfficiency()})};
        mc.f_91062_.m_92889_(poseStack, info[0], 80.0f - (float)mc.f_91062_.m_92852_((FormattedText)info[0]) / 2.0f, 0.0f, Color.BLACK.getRGB());
        mc.f_91062_.m_92889_(poseStack, info[1], 80.0f - (float)mc.f_91062_.m_92852_((FormattedText)info[1]) / 2.0f, 12.0f, Color.BLACK.getRGB());
        mc.f_91062_.m_92889_(poseStack, info[2], 80.0f - (float)mc.f_91062_.m_92852_((FormattedText)info[2]) / 2.0f, 24.0f, Color.BLACK.getRGB());
        mc.f_91062_.m_92889_(poseStack, info[3], 80.0f - (float)mc.f_91062_.m_92852_((FormattedText)info[3]) / 2.0f, 36.0f, Color.BLACK.getRGB());
    }

    public static class Recipe {
        private final FluidStack input;
        private final ReactorModeratorRegistry.IModeratorProperties moderatorProperties;

        public Recipe(FluidStack input, ReactorModeratorRegistry.IModeratorProperties moderatorProperties) {
            this.input = input;
            this.moderatorProperties = moderatorProperties;
        }

        public FluidStack getInput() {
            return this.input;
        }

        public ReactorModeratorRegistry.IModeratorProperties getModeratorProperties() {
            return this.moderatorProperties;
        }
    }
}

