/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorRedstonePort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorRedstonePortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortSelection;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorRedstonePortTriggers;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.multiblock.ITickableMultiblockTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorRedstonePortTile
extends ReactorBaseTile
implements MenuProvider,
ITickableMultiblockTile,
IHasUpdatableState<ReactorRedstonePortState>,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTile(value="reactor_redstone_port")
    public static final BlockEntityType.BlockEntitySupplier<ReactorRedstonePortTile> SUPPLIER = new RegisterTile.Producer(ReactorRedstonePortTile::new);
    public final ReactorRedstonePortState reactorRedstonePortState = new ReactorRedstonePortState(this);
    private boolean isEmitting;
    double mainVal = 0.0;
    double secondaryVal = 0.0;
    Direction powerOutputDirection = null;
    private boolean isPowered = false;
    private boolean wasPowered = false;
    private boolean isLit = false;
    private final ReactorRedstonePortState currentChanges = new ReactorRedstonePortState(this);

    public ReactorRedstonePortTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public boolean isEmitting(Direction side) {
        if (side.m_122424_() != this.powerOutputDirection) {
            return false;
        }
        return this.isEmitting;
    }

    public void updatePowered() {
        if (this.powerOutputDirection == null) {
            return;
        }
        assert (this.f_58857_ != null);
        this.isPowered = this.f_58857_.m_46616_(this.f_58858_.m_121945_(this.powerOutputDirection), this.powerOutputDirection);
    }

    public void tick() {
        boolean shouldBeEmitting = false;
        boolean shouldLight = false;
        block0 : switch (this.reactorRedstonePortState.selectedTab) {
            case INPUT_ACTIVITY: {
                shouldLight = this.isPowered;
                if (this.reactorRedstonePortState.triggerPS.toBool()) {
                    if (this.wasPowered == this.isPowered) break;
                    ((ReactorMultiblockController)this.controller()).setActive(this.isPowered ? ReactorActivity.ACTIVE : ReactorActivity.INACTIVE);
                    break;
                }
                if (this.wasPowered || !this.isPowered) break;
                ((ReactorMultiblockController)this.controller()).toggleActive();
                break;
            }
            case INPUT_CONTROL_ROD_INSERTION: {
                shouldLight = this.isPowered;
                if (this.reactorRedstonePortState.triggerPS.toBool()) {
                    if (this.wasPowered == this.isPowered) break;
                    if (this.isPowered) {
                        ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(this.mainVal);
                        break;
                    }
                    ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(this.secondaryVal);
                    break;
                }
                if (this.wasPowered || !this.isPowered) break;
                switch (this.reactorRedstonePortState.triggerMode) {
                    case 0: {
                        ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(((ReactorMultiblockController)this.controller()).controlRodLevel(0) + this.mainVal);
                        break block0;
                    }
                    case 1: {
                        ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(((ReactorMultiblockController)this.controller()).controlRodLevel(0) - this.mainVal);
                        break block0;
                    }
                    case 2: {
                        ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(this.mainVal);
                        break block0;
                    }
                }
                break;
            }
            case INPUT_EJECT_WASTE: {
                shouldLight = this.isPowered;
                if (this.wasPowered || !this.isPowered) break;
                ((ReactorMultiblockController)this.controller()).ejectWaste();
                break;
            }
            case OUTPUT_FUEL_TEMP: {
                double fuelTemp;
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null || (fuelTemp = reactorSim.fuelHeat()) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_CASING_TEMP: {
                double casingTemperature;
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null || (casingTemperature = reactorSim.stackHeat()) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_FUEL_ENRICHMENT: {
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null) break;
                double fuelPercent = reactorSim.fuelTank().fuel();
                fuelPercent /= (double)reactorSim.fuelTank().totalStored();
                if ((fuelPercent *= 100.0) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_FUEL_AMOUNT: {
                double fuelAmount;
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null || (fuelAmount = (double)reactorSim.fuelTank().fuel()) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_WASTE_AMOUNT: {
                double wasteAmount;
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null || (wasteAmount = (double)reactorSim.fuelTank().waste()) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
                break;
            }
            case OUTPUT_ENERGY_AMOUNT: {
                IReactorSimulation.IBattery battery;
                IReactorSimulation reactorSim = ((ReactorMultiblockController)this.controller()).simulation();
                if (reactorSim == null || (battery = reactorSim.battery()) == null) break;
                double energyAmount = battery.stored();
                energyAmount /= (double)battery.capacity();
                if ((energyAmount *= 100.0) < this.mainVal != this.reactorRedstonePortState.triggerAB.toBool()) break;
                shouldBeEmitting = true;
            }
        }
        shouldLight |= shouldBeEmitting;
        if (shouldBeEmitting != this.isEmitting || this.wasPowered != this.isPowered) {
            if (this.powerOutputDirection == null) {
                return;
            }
            this.isEmitting = shouldBeEmitting;
            this.wasPowered = this.isPowered;
            assert (this.f_58857_ != null);
            BlockPos updatePos = this.f_58858_.m_121945_(this.powerOutputDirection);
            this.f_58857_.m_6289_(this.m_58899_(), this.m_58900_().m_60734_());
            this.f_58857_.m_6289_(updatePos, this.f_58857_.m_8055_(updatePos).m_60734_());
        }
        if (this.isLit != shouldLight) {
            this.isLit = shouldLight;
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ReactorRedstonePort.IS_LIT_BOOLEAN_PROPERTY, (Comparable)Boolean.valueOf(this.isLit)));
        }
        this.m_6596_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)ReactorRedstonePort.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ReactorRedstonePortContainer(windowId, this.f_58858_, player);
    }

    public ReactorRedstonePortState getCurrentChanges() {
        return this.currentChanges;
    }

    public ReactorRedstonePortState getState() {
        this.updateState();
        return this.reactorRedstonePortState;
    }

    public void updateState() {
    }

    public void applyChanges() {
        this.reactorRedstonePortState.selectedTab = this.currentChanges.selectedTab;
        this.reactorRedstonePortState.triggerPS = this.currentChanges.triggerPS;
        this.reactorRedstonePortState.triggerAB = this.currentChanges.triggerAB;
        this.reactorRedstonePortState.triggerMode = this.currentChanges.triggerMode;
        this.reactorRedstonePortState.textBufferA = this.currentChanges.textBufferA;
        this.reactorRedstonePortState.textBufferB = this.currentChanges.textBufferB;
        this.mainVal = !this.reactorRedstonePortState.textBufferA.isEmpty() ? Double.parseDouble(this.reactorRedstonePortState.textBufferA) : 0.0;
        this.secondaryVal = !this.reactorRedstonePortState.textBufferB.isEmpty() ? Double.parseDouble(this.reactorRedstonePortState.textBufferB) : 0.0;
    }

    public void revertChanges() {
        this.currentChanges.selectedTab = this.reactorRedstonePortState.selectedTab;
        this.currentChanges.triggerPS = this.reactorRedstonePortState.triggerPS;
        this.currentChanges.triggerAB = this.reactorRedstonePortState.triggerAB;
        this.currentChanges.triggerMode = this.reactorRedstonePortState.triggerMode;
        this.currentChanges.textBufferA = this.reactorRedstonePortState.textBufferA;
        this.currentChanges.textBufferB = this.reactorRedstonePortState.textBufferB;
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        switch (requestName) {
            case "setSelectedTab": {
                this.currentChanges.selectedTab = ReactorRedstonePortSelection.fromInt((Integer)requestData);
                break;
            }
            case "setTriggerPS": {
                this.currentChanges.triggerPS = ReactorRedstonePortTriggers.fromBool((Boolean)requestData);
                break;
            }
            case "setTriggerAB": {
                this.currentChanges.triggerAB = ReactorRedstonePortTriggers.fromBool((Boolean)requestData);
                break;
            }
            case "setTriggerMode": {
                int triggerMode = (Integer)requestData;
                if (triggerMode >= 0 && triggerMode <= 2) {
                    this.currentChanges.triggerMode = triggerMode;
                    break;
                }
                this.currentChanges.triggerMode = 2;
                break;
            }
            case "setTextBufferA": {
                this.currentChanges.textBufferA = (String)requestData;
                break;
            }
            case "setTextBufferB": {
                this.currentChanges.textBufferB = (String)requestData;
                break;
            }
            case "revertChanges": {
                System.out.println("No longer implemented!");
                break;
            }
            case "applyChanges": {
                this.applyChanges();
                break;
            }
            default: {
                super.runRequest(requestName, requestData);
            }
        }
    }

    protected CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        compound.m_128405_("settingId", this.reactorRedstonePortState.selectedTab.toInt());
        compound.m_128379_("triggerPulseOrSignal", this.reactorRedstonePortState.triggerPS.toBool());
        compound.m_128379_("triggerAboveOrBelow", this.reactorRedstonePortState.triggerAB.toBool());
        compound.m_128405_("mode", this.reactorRedstonePortState.triggerMode);
        compound.m_128359_("mainBuffer", this.reactorRedstonePortState.textBufferA);
        compound.m_128359_("secondBuffer", this.reactorRedstonePortState.textBufferB);
        compound.m_128379_("isPowered", this.isPowered);
        compound.m_128379_("isEmitting", this.isEmitting);
        return compound;
    }

    protected void readNBT(CompoundTag compound) {
        super.readNBT(compound);
        if (compound.m_128441_("settingId")) {
            this.reactorRedstonePortState.selectedTab = ReactorRedstonePortSelection.fromInt(compound.m_128451_("settingId"));
        }
        if (compound.m_128441_("triggerPulseOrSignal")) {
            this.reactorRedstonePortState.triggerPS = ReactorRedstonePortTriggers.fromBool(compound.m_128471_("triggerPulseOrSignal"));
        }
        if (compound.m_128441_("triggerAboveOrBelow")) {
            this.reactorRedstonePortState.triggerAB = ReactorRedstonePortTriggers.fromBool(compound.m_128471_("triggerAboveOrBelow"));
        }
        if (compound.m_128441_("mode")) {
            this.reactorRedstonePortState.triggerMode = compound.m_128451_("mode");
        }
        if (compound.m_128441_("mainBuffer")) {
            this.reactorRedstonePortState.textBufferA = compound.m_128461_("mainBuffer");
        }
        if (compound.m_128441_("secondBuffer")) {
            this.reactorRedstonePortState.textBufferB = compound.m_128461_("secondBuffer");
        }
        if (compound.m_128441_("isPowered")) {
            this.wasPowered = this.isPowered = compound.m_128471_("isPowered");
        }
        this.revertChanges();
        this.applyChanges();
    }

    public void onAssembly() {
        this.powerOutputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.updatePowered();
    }

    public void onDisassembly() {
        this.powerOutputDirection = null;
        this.updatePowered();
    }
}

