/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base;

import java.util.ArrayList;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3d;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3dc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;

public class SimUtil {
    public static final Vector2ic[] cardinalDirections = new Vector2ic[]{new Vector2i(1, 0), new Vector2i(-1, 0), new Vector2i(0, 1), new Vector2i(0, -1)};
    public static final Vector3ic[] axisDirections = new Vector3ic[]{new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 0, -1)};
    public static final ArrayList<ArrayList<RayStep>> rays = new ArrayList();

    @OnModLoad
    private static void onModLoad() {
    }

    static {
        double TTL = Config.CONFIG.Reactor.IrradiationDistance;
        int SimulationRays = Config.CONFIG.Reactor.SimulationRays;
        double SimulationRaysDouble = SimulationRays - 1;
        Vector3d[] rayDirections = new Vector3d[SimulationRays];
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < SimulationRays; ++i) {
            double y = 1.0 - (double)i * 2.0 / SimulationRaysDouble;
            double radius = Math.sqrt(1.0 - y * y);
            double theta = phi * (double)i;
            double x = Math.cos(theta) * radius;
            double z = Math.sin(theta) * radius;
            rayDirections[i] = new Vector3d(x, y, z).normalize();
        }
        Vector3d radiationDirection = new Vector3d();
        Vector3d currentSegment = new Vector3d();
        Vector3d currentSegmentStart = new Vector3d();
        Vector3d currentSegmentEnd = new Vector3d();
        Vector3d currentSectionBlock = new Vector3d();
        Vector3d planes = new Vector3d();
        Vector3d[] intersections = new Vector3d[]{new Vector3d(), new Vector3d(), new Vector3d()};
        for (Vector3d rayDirection : rayDirections) {
            ArrayList<RayStep> raySteps = new ArrayList<RayStep>();
            radiationDirection.set((Vector3dc)rayDirection);
            radiationDirection.normalize();
            currentSegmentStart.set((Vector3dc)radiationDirection);
            currentSegmentStart.mul(1.0 / Math.abs(currentSegmentStart.get(currentSegmentStart.maxComponent())));
            currentSegmentStart.mul(0.5);
            radiationDirection.mul(TTL + currentSegmentStart.length());
            double processedLength = 0.0;
            double totalLength = radiationDirection.length();
            currentSegmentStart.set(0.0);
            planes.set((Vector3dc)radiationDirection);
            planes.absolute();
            planes.div(radiationDirection);
            planes.mul(0.5);
            boolean firstIteration = true;
            while (true) {
                for (int i = 0; i < 3; ++i) {
                    Vector3d intersection = intersections[i];
                    intersection.set((Vector3dc)radiationDirection);
                    double component = intersection.get(i);
                    double plane = planes.get(i);
                    intersection.mul(plane / component);
                }
                int minVec = 0;
                double minLength = Double.POSITIVE_INFINITY;
                for (int i = 0; i < 3; ++i) {
                    double length = intersections[i].lengthSquared();
                    if (!(length < minLength)) continue;
                    minVec = i;
                    minLength = length;
                }
                planes.setComponent(minVec, planes.get(minVec) + planes.get(minVec) / Math.abs(planes.get(minVec)));
                currentSegmentEnd.set((Vector3dc)intersections[minVec]);
                currentSegment.set((Vector3dc)currentSegmentEnd).sub((Vector3dc)currentSegmentStart);
                currentSectionBlock.set((Vector3dc)currentSegmentEnd).sub((Vector3dc)currentSegmentStart).mul(0.5).add(0.5, 0.5, 0.5).add((Vector3dc)currentSegmentStart).floor();
                double segmentLength = currentSegment.length();
                boolean breakAfterLoop = processedLength + segmentLength >= totalLength;
                segmentLength = Math.min(totalLength - processedLength, segmentLength);
                if (!firstIteration && segmentLength != 0.0) {
                    raySteps.add(new RayStep(new Vector3i((Vector3dc)currentSectionBlock, 0), segmentLength));
                }
                firstIteration = false;
                processedLength += segmentLength;
                if (breakAfterLoop) break;
                currentSegmentStart.set((Vector3dc)currentSegmentEnd);
            }
            rays.add(raySteps);
        }
    }

    public static class RayStep {
        public final Vector3i offset;
        public final double length;

        private RayStep(Vector3i offset, double length) {
            this.offset = offset;
            this.length = length;
        }
    }

    public static class ControlRod
    implements IReactorSimulation.ControlRod {
        public final int x;
        public final int z;
        public double insertion = 0.0;

        public ControlRod(int x, int z) {
            this.x = x;
            this.z = z;
        }

        @Override
        public double insertion() {
            return this.insertion;
        }

        @Override
        public void setInsertion(double insertion) {
            this.insertion = insertion;
        }
    }
}

