/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.InventoryUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.items.ItemStackHandler;

public class HeartAmuletRecipe
extends ShapelessRecipe {
    public HeartAmuletRecipe(ResourceLocation id, String group, ItemStack stack, NonNullList<Ingredient> list) {
        super(id, group, stack, list);
    }

    public ItemStack m_5874_(CraftingContainer p_44260_) {
        ItemStack oldCanister = ItemStack.f_41583_;
        for (int i = 0; i < p_44260_.m_6643_(); ++i) {
            ItemStack input = p_44260_.m_8020_(i);
            if (input.m_41720_() != RegistryHandler.HEART_AMULET.get()) continue;
            oldCanister = input;
            break;
        }
        ItemStack stack = super.m_5874_(p_44260_);
        ItemStackHandler oldInv = InventoryUtil.createVirtualInventory(4, oldCanister);
        ItemStackHandler newInv = InventoryUtil.createVirtualInventory(5, stack);
        for (int i = 0; i < oldInv.getSlots(); ++i) {
            newInv.setStackInSlot(i, oldInv.getStackInSlot(i));
        }
        InventoryUtil.serializeInventory(newInv, stack);
        return stack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RegistryHandler.HEART_AMULET_RECIPE_SERIALIZER.get();
    }

    public static class BHCSerializer
    implements RecipeSerializer<HeartAmuletRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("bhc", "amulet_shapeless");

        public HeartAmuletRecipe fromJson(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = BHCSerializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new HeartAmuletRecipe(p_44290_, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)p_44276_.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public HeartAmuletRecipe fromNetwork(ResourceLocation p_44293_, FriendlyByteBuf p_44294_) {
            String s = p_44294_.m_130277_();
            int i = p_44294_.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44294_));
            }
            ItemStack itemstack = p_44294_.m_130267_();
            return new HeartAmuletRecipe(p_44293_, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf p_44281_, HeartAmuletRecipe p_44282_) {
            p_44281_.m_130070_(p_44282_.m_6076_());
            p_44281_.m_130130_(p_44282_.m_7527_().size());
            for (Ingredient ingredient : p_44282_.m_7527_()) {
                ingredient.m_43923_(p_44281_);
            }
            p_44281_.m_130055_(p_44282_.m_8043_());
        }
    }
}

