/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item.curio.hands;

import artifacts.common.config.item.ItemConfig;
import artifacts.common.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.TierSortingRegistry;

public class DiggingClawsConfig
extends ItemConfig {
    @Nullable
    public Tier toolTier;
    public ForgeConfigSpec.DoubleValue miningSpeedBonus;
    public ForgeConfigSpec.ConfigValue<String> toolTierValue;

    public DiggingClawsConfig(ForgeConfigSpec.Builder builder) {
        super(builder, ModItems.DIGGING_CLAWS.getId().m_135815_(), "Affects how many blocks the player can break using the digging claws before breaking");
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        this.miningSpeedBonus = builder.worldRestart().comment("Mining speed bonus applied by digging claws").translation(this.translate("mining_speed_bonus")).defineInRange("mining_speed_bonus", 3.2, 0.0, Double.POSITIVE_INFINITY);
        this.toolTierValue = builder.comment(new String[]{"The tool tier of the digging claws", "To modify mineable blocks, use the 'artifacts:mineable/digging_claws' block tag"}).translation(this.translate("tool_tier")).define("tool_tier", (Object)new ResourceLocation("stone").toString());
    }

    @Override
    public void bake() {
        ResourceLocation location = new ResourceLocation((String)this.toolTierValue.get());
        this.toolTier = TierSortingRegistry.byName((ResourceLocation)location);
    }
}

