/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import artifacts.common.config.item.EverlastingFoodConfig;
import artifacts.common.config.item.ItemConfig;
import artifacts.common.config.item.UmbrellaConfig;
import artifacts.common.config.item.curio.WhoopeeCushionConfig;
import artifacts.common.config.item.curio.belt.AntidoteVesselConfig;
import artifacts.common.config.item.curio.belt.CloudInABottleConfig;
import artifacts.common.config.item.curio.belt.CrystalHeartConfig;
import artifacts.common.config.item.curio.belt.HeliumFlamingoConfig;
import artifacts.common.config.item.curio.belt.ObsidianSkullConfig;
import artifacts.common.config.item.curio.belt.UniversalAttractorConfig;
import artifacts.common.config.item.curio.feet.BunnyHoppersConfig;
import artifacts.common.config.item.curio.feet.FlippersConfig;
import artifacts.common.config.item.curio.feet.RunningShoesConfig;
import artifacts.common.config.item.curio.hands.DiggingClawsConfig;
import artifacts.common.config.item.curio.hands.FeralClawsConfig;
import artifacts.common.config.item.curio.hands.FireGauntletConfig;
import artifacts.common.config.item.curio.hands.GoldenHookConfig;
import artifacts.common.config.item.curio.hands.PocketPistonConfig;
import artifacts.common.config.item.curio.hands.PowerGloveConfig;
import artifacts.common.config.item.curio.hands.VampiricGloveConfig;
import artifacts.common.config.item.curio.head.DrinkingHatConfig;
import artifacts.common.config.item.curio.head.SuperstitiousHatConfig;
import artifacts.common.config.item.curio.head.VillagerHatConfig;
import artifacts.common.config.item.curio.necklace.CrossNecklaceConfig;
import artifacts.common.config.item.curio.necklace.FlamePendantConfig;
import artifacts.common.config.item.curio.necklace.LuckyScarfConfig;
import artifacts.common.config.item.curio.necklace.PanicNecklaceConfig;
import artifacts.common.config.item.curio.necklace.PendantConfig;
import artifacts.common.config.item.curio.necklace.ShockPendantConfig;
import artifacts.common.config.item.curio.necklace.ThornPendantConfig;
import artifacts.common.init.ModItems;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ServerConfig {
    public Set<Item> cosmetics = Collections.emptySet();
    public final Map<Item, ItemConfig> items = new HashMap<Item, ItemConfig>();
    public final AntidoteVesselConfig antidoteVessel;
    public final ItemConfig aquaDashers;
    public final BunnyHoppersConfig bunnyHoppers;
    public final ItemConfig charmOfSinking;
    public final CloudInABottleConfig cloudInABottle;
    public final CrossNecklaceConfig crossNecklace;
    public final CrystalHeartConfig crystalHeart;
    public final DiggingClawsConfig diggingClaws;
    public final FeralClawsConfig feralClaws;
    public final FireGauntletConfig fireGauntlet;
    public final FlamePendantConfig flamePendant;
    public final FlippersConfig flippers;
    public final GoldenHookConfig goldenHook;
    public final HeliumFlamingoConfig heliumFlamingo;
    public final ItemConfig kittySlippers;
    public final LuckyScarfConfig luckyScarf;
    public final ItemConfig nightVisionGoggles;
    public final ObsidianSkullConfig obsidianSkull;
    public final PanicNecklaceConfig panicNecklace;
    public final PocketPistonConfig pocketPiston;
    public final PowerGloveConfig powerGlove;
    public final RunningShoesConfig runningShoes;
    public final ItemConfig scarfOfInvisibility;
    public final ShockPendantConfig shockPendant;
    public final ItemConfig snorkel;
    public final ItemConfig steadfastSpikes;
    public final SuperstitiousHatConfig superstitiousHat;
    public final ThornPendantConfig thornPendant;
    public final UmbrellaConfig umbrella;
    public final UniversalAttractorConfig universalAttractor;
    public final VampiricGloveConfig vampiricGlove;
    public final VillagerHatConfig villagerHat;
    public final WhoopeeCushionConfig whoopeeCushion;
    public final Map<Item, EverlastingFoodConfig> everlastingFoods = new HashMap<Item, EverlastingFoodConfig>();
    public final Map<Item, DrinkingHatConfig> drinkingHats = new HashMap<Item, DrinkingHatConfig>();
    public final Map<Item, PendantConfig> pendants = new HashMap<Item, PendantConfig>();
    private final ForgeConfigSpec.ConfigValue<List<String>> cosmeticsValue;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("items");
        this.cosmeticsValue = builder.worldRestart().comment(new String[]{"List of cosmetic-only items. All items in this list will have their effects disabled", "To blacklist all items, use \"artifacts:*\"", "Note: blacklisting an item while it is equipped may have unintended side effects"}).translation("artifacts.config.server.cosmetics").define("cosmetics", (Object)Lists.newArrayList((Object[])new String[]{""}));
        this.antidoteVessel = new AntidoteVesselConfig(builder);
        this.aquaDashers = new ItemConfig(builder, ModItems.AQUA_DASHERS, "Affects how many seconds the player can run on fluids using the aqua dashers before breaking");
        this.bunnyHoppers = new BunnyHoppersConfig(builder);
        this.charmOfSinking = new ItemConfig(builder, ModItems.CHARM_OF_SINKING, "Affects how many seconds the player can stay underwater using the charm of sinking before breaking");
        this.cloudInABottle = new CloudInABottleConfig(builder);
        this.crossNecklace = new CrossNecklaceConfig(builder);
        this.crystalHeart = new CrystalHeartConfig(builder);
        this.diggingClaws = new DiggingClawsConfig(builder);
        EverlastingFoodConfig eternalSteak = new EverlastingFoodConfig(builder, ModItems.ETERNAL_STEAK);
        EverlastingFoodConfig everlastingBeef = new EverlastingFoodConfig(builder, ModItems.EVERLASTING_BEEF);
        this.feralClaws = new FeralClawsConfig(builder);
        this.fireGauntlet = new FireGauntletConfig(builder);
        this.flamePendant = new FlamePendantConfig(builder);
        this.flippers = new FlippersConfig(builder);
        this.goldenHook = new GoldenHookConfig(builder);
        this.heliumFlamingo = new HeliumFlamingoConfig(builder);
        this.kittySlippers = new ItemConfig(builder, ModItems.KITTY_SLIPPERS, "Affects how many creepers the player can attack using the kitty slippers before breaking");
        this.luckyScarf = new LuckyScarfConfig(builder);
        this.nightVisionGoggles = new ItemConfig(builder, ModItems.NIGHT_VISION_GOGGLES, "Affects how many seconds the night vision effect should apply before breaking");
        DrinkingHatConfig noveltyDrinkingHat = new DrinkingHatConfig(builder, ModItems.NOVELTY_DRINKING_HAT);
        this.obsidianSkull = new ObsidianSkullConfig(builder);
        this.panicNecklace = new PanicNecklaceConfig(builder);
        DrinkingHatConfig plasticDrinkingHat = new DrinkingHatConfig(builder, ModItems.PLASTIC_DRINKING_HAT);
        this.pocketPiston = new PocketPistonConfig(builder);
        this.powerGlove = new PowerGloveConfig(builder);
        this.runningShoes = new RunningShoesConfig(builder);
        this.scarfOfInvisibility = new ItemConfig(builder, ModItems.SCARF_OF_INVISIBILITY, "Affects how many seconds the invisibility effect should apply before breaking");
        this.shockPendant = new ShockPendantConfig(builder);
        this.snorkel = new ItemConfig(builder, ModItems.SNORKEL, "Affects how many seconds the player can stay underwater using the snorkel before breaking");
        this.steadfastSpikes = new ItemConfig(builder, ModItems.STEADFAST_SPIKES, "Affects how many times the player can be hit while wearing steadfast spikes before breaking");
        this.superstitiousHat = new SuperstitiousHatConfig(builder);
        this.thornPendant = new ThornPendantConfig(builder);
        this.umbrella = new UmbrellaConfig(builder);
        this.universalAttractor = new UniversalAttractorConfig(builder);
        this.vampiricGlove = new VampiricGloveConfig(builder);
        this.villagerHat = new VillagerHatConfig(builder);
        this.whoopeeCushion = new WhoopeeCushionConfig(builder);
        this.drinkingHats.put((Item)ModItems.NOVELTY_DRINKING_HAT.get(), noveltyDrinkingHat);
        this.drinkingHats.put((Item)ModItems.PLASTIC_DRINKING_HAT.get(), plasticDrinkingHat);
        this.everlastingFoods.put((Item)ModItems.ETERNAL_STEAK.get(), eternalSteak);
        this.everlastingFoods.put((Item)ModItems.EVERLASTING_BEEF.get(), everlastingBeef);
        this.pendants.put((Item)ModItems.FLAME_PENDANT.get(), this.flamePendant);
        this.pendants.put((Item)ModItems.SHOCK_PENDANT.get(), this.shockPendant);
        this.pendants.put((Item)ModItems.THORN_PENDANT.get(), this.thornPendant);
        this.addItemConfigs();
        builder.pop();
    }

    private void addItemConfigs() {
        this.items.put((Item)ModItems.ANTIDOTE_VESSEL.get(), this.antidoteVessel);
        this.items.put((Item)ModItems.AQUA_DASHERS.get(), this.aquaDashers);
        this.items.put((Item)ModItems.BUNNY_HOPPERS.get(), this.bunnyHoppers);
        this.items.put((Item)ModItems.CHARM_OF_SINKING.get(), this.charmOfSinking);
        this.items.put((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), this.cloudInABottle);
        this.items.put((Item)ModItems.CROSS_NECKLACE.get(), this.crossNecklace);
        this.items.put((Item)ModItems.CRYSTAL_HEART.get(), this.crystalHeart);
        this.items.put((Item)ModItems.DIGGING_CLAWS.get(), this.diggingClaws);
        this.items.put((Item)ModItems.FERAL_CLAWS.get(), this.feralClaws);
        this.items.put((Item)ModItems.FIRE_GAUNTLET.get(), this.fireGauntlet);
        this.items.put((Item)ModItems.FLAME_PENDANT.get(), this.flamePendant);
        this.items.put((Item)ModItems.FLIPPERS.get(), this.flippers);
        this.items.put((Item)ModItems.GOLDEN_HOOK.get(), this.goldenHook);
        this.items.put((Item)ModItems.HELIUM_FLAMINGO.get(), this.heliumFlamingo);
        this.items.put((Item)ModItems.KITTY_SLIPPERS.get(), this.kittySlippers);
        this.items.put((Item)ModItems.LUCKY_SCARF.get(), this.luckyScarf);
        this.items.put((Item)ModItems.NIGHT_VISION_GOGGLES.get(), this.nightVisionGoggles);
        this.items.put((Item)ModItems.OBSIDIAN_SKULL.get(), this.obsidianSkull);
        this.items.put((Item)ModItems.PANIC_NECKLACE.get(), this.panicNecklace);
        this.items.put((Item)ModItems.POCKET_PISTON.get(), this.pocketPiston);
        this.items.put((Item)ModItems.POWER_GLOVE.get(), this.powerGlove);
        this.items.put((Item)ModItems.RUNNING_SHOES.get(), this.runningShoes);
        this.items.put((Item)ModItems.SCARF_OF_INVISIBILITY.get(), this.scarfOfInvisibility);
        this.items.put((Item)ModItems.SHOCK_PENDANT.get(), this.shockPendant);
        this.items.put((Item)ModItems.SNORKEL.get(), this.snorkel);
        this.items.put((Item)ModItems.STEADFAST_SPIKES.get(), this.steadfastSpikes);
        this.items.put((Item)ModItems.SUPERSTITIOUS_HAT.get(), this.superstitiousHat);
        this.items.put((Item)ModItems.THORN_PENDANT.get(), this.thornPendant);
        this.items.put((Item)ModItems.UMBRELLA.get(), this.umbrella);
        this.items.put((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), this.universalAttractor);
        this.items.put((Item)ModItems.VAMPIRIC_GLOVE.get(), this.vampiricGlove);
        this.items.put((Item)ModItems.VILLAGER_HAT.get(), this.villagerHat);
        this.items.put((Item)ModItems.WHOOPEE_CUSHION.get(), this.whoopeeCushion);
        this.items.putAll(this.drinkingHats);
        this.items.putAll(this.everlastingFoods);
        this.items.putAll(this.pendants);
    }

    public void bake() {
        this.cosmetics = ((List)this.cosmeticsValue.get()).contains("artifacts:*") ? ForgeRegistries.ITEMS.getValues().stream().filter(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("artifacts")).collect(Collectors.toSet()) : ((List)this.cosmeticsValue.get()).stream().map(ResourceLocation::new).filter(registryName -> registryName.m_135827_().equals("artifacts")).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).collect(Collectors.toSet());
        this.items.forEach((item, config) -> config.bake());
    }

    public boolean isCosmetic(Item item) {
        return this.cosmetics.contains(item);
    }
}

