/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.mixin;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RelayTile.class}, remap=false)
public abstract class RelayTileMixin
extends AbstractSourceMachine {
    @Shadow
    private BlockPos toPos;
    @Shadow
    private BlockPos fromPos;
    @Shadow
    public boolean disabled;

    @Shadow
    public abstract int getMaxDistance();

    @Shadow
    public abstract boolean setTakeFrom(BlockPos var1);

    @Shadow
    public abstract boolean setSendTo(BlockPos var1);

    public RelayTileMixin(BlockEntityType<?> manaTile, BlockPos pos, BlockState state) {
        super(manaTile, pos, state);
    }

    @Inject(method={"setSendTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCapSetSend(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        LazyOptional cap;
        BlockEntity be;
        if (BlockUtil.distanceFrom((BlockPos)pos, (BlockPos)this.f_58858_) <= (double)this.getMaxDistance() && !pos.equals((Object)this.m_58899_()) && (be = Objects.requireNonNull(this.f_58857_).m_7702_(pos)) != null && (cap = be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(this.m_58899_(), pos))).isPresent()) {
            this.toPos = pos;
            this.updateBlock();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onFinishedConnectionFirst"}, at={@At(value="HEAD")}, cancellable=true)
    public void addCapFinishedConnectFirst(BlockPos storedPos, LivingEntity storedEntity, Player playerEntity, CallbackInfo ci) {
        if (this.setSendTo(storedPos.m_7949_())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
            ParticleUtil.beam((BlockPos)storedPos, (BlockPos)this.f_58858_, (Level)this.f_58857_);
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.fail"));
        }
        ci.cancel();
    }

    @Inject(method={"onFinishedConnectionLast"}, at={@At(value="HEAD")}, cancellable=true)
    public void addCapFinishedConnectLast(BlockPos storedPos, LivingEntity storedEntity, Player playerEntity, CallbackInfo ci) {
        if (this.setTakeFrom(storedPos.m_7949_())) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.connections.take", (Object[])new Object[]{DominionWand.getPosString((BlockPos)storedPos)}));
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.fail"));
        }
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void addCapToTick(CallbackInfo ci) {
        LazyOptional cap;
        BlockEntity be;
        ci.cancel();
        Objects.requireNonNull(this.f_58857_);
        if (this.f_58857_.f_46443_ || this.disabled) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L != 0L) {
            return;
        }
        if (this.fromPos != null && this.f_58857_.m_46749_(this.fromPos)) {
            be = this.f_58857_.m_7702_(this.fromPos);
            if (be == null) {
                this.fromPos = null;
                this.updateBlock();
                return;
            }
            cap = be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(this.m_58899_(), this.fromPos));
            cap.ifPresent(tile -> {
                if (tile.relayCanTakePower() && this.transferSource((ISourceTile)tile, (ISourceTile)this) > 0) {
                    this.updateBlock();
                    ParticleUtil.spawnFollowProjectile((Level)this.f_58857_, (BlockPos)this.fromPos, (BlockPos)this.f_58858_);
                }
            });
        }
        if (this.toPos != null && this.f_58857_.m_46749_(this.toPos)) {
            be = this.f_58857_.m_7702_(this.toPos);
            if (be == null) {
                this.toPos = null;
                this.updateBlock();
            } else {
                cap = be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(this.m_58899_(), this.toPos));
                cap.ifPresent(tile -> {
                    if (tile.canAcceptSource() && this.transferSource((ISourceTile)this, (ISourceTile)tile) > 0) {
                        this.updateBlock();
                        ParticleUtil.spawnFollowProjectile((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockPos)this.toPos);
                    }
                });
            }
        }
    }
}

