/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.item;

import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.Upgrades;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.me.common.MEStorageMenu;
import gripe._90.arseng.definition.ArsEngCore;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.me.cell.ISourceCellItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;

public class PortableSourceCellItem
extends AbstractPortableCell
implements ISourceCellItem {
    private final StorageTier tier;

    public PortableSourceCellItem(Item.Properties props, StorageTier tier) {
        super(MEStorageMenu.PORTABLE_FLUID_CELL_TYPE, props);
        this.tier = tier;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    @Override
    public long getTotalBytes() {
        return 50L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    public ResourceLocation getRecipeId() {
        return ArsEngCore.makeId(Objects.requireNonNull(this.getRegistryName()).m_135815_());
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 * (double)(Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack)) + 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initColours(RegisterColorHandlersEvent.Item event) {
        ArsEngItems.getPortables().forEach(portable -> event.register(AbstractPortableCell::getColor, new ItemLike[]{portable}));
    }
}

