/*
 * Decompiled with CFR 0.152.
 */
package com.vyklade.ars_armiger.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.RegistryHelper;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.SpotlightPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.vyklade.ars_armiger.ArsNouveauRegistry;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class PatchouliProvider
extends com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider {
    static String root = "ars_armiger";

    public PatchouliProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
            this.addGlyphPage(spell);
        }
        PatchouliBuilder builder = new PatchouliBuilder(EQUIPMENT, "ars_armiger.page.tetra_weapons").withIcon("tetra:modular_sword{\"sword/basic_blade_material\":\"basic_blade/source_gem\",\"sword/basic_hilt_material\":\"basic_hilt/stick\",\"sword/blade\":\"sword/basic_blade\",\"sword/decorative_pommel\":\"decorative_pommel/gold\",\"sword/guard\":\"sword/makeshift_guard\",\"sword/hilt\":\"sword/basic_hilt\",\"sword/makeshift_guard_material\":\"makeshift_guard/gold\",\"sword/pommel\":\"sword/decorative_pommel\",\"sword/blade:spellstrike\":1}").withPage((IPatchouliPage)new SpotlightPage("tetra:holo{\"id\":\"9503de92-046c-4d61-8afe-8c0d71c6afae\",\"holo/core\":\"holo/core\",\"holo/core_material\":\"core/dim\",\"holo/frame\":\"holo/frame\",\"holo/frame_material\":\"frame/ancient\"}").withTitle("ars_armiger.page.tetra_weapons").withText("ars_armiger.page.tetra_weapons.page1.body")).withPage((IPatchouliPage)new SpotlightPage("tetra:modular_sword{\"sword/hilt:hilt/wrap/end_fiber\":0,\"sword/basic_blade_material\":\"basic_blade/source_gem\",\"sword/basic_hilt_material\":\"basic_hilt/archwood\",\"sword/binding_material\":\"sword_binding/blaze_fiber\",\"sword/blade\":\"sword/basic_blade\",\"sword/decorative_pommel_material\":\"decorative_pommel/diamond\",\"sword/guard\":\"sword/binding\",\"sword/hilt\":\"sword/basic_hilt\",\"sword/pommel\":\"sword/decorative_pommel\"}").withTitle("ars_armiger.page.tetra_weapons.page2.title").withText("ars_armiger.page.tetra_weapons.page2.body")).withPage((IPatchouliPage)new SpotlightPage("tetra:modular_single{\"single/head:single/spellstrikefocus_arcane\":0,\"single/handle\":\"single/long_handle\",\"single/head\":\"single/spearhead\",\"single/long_handle_material\":\"long_handle/archwood\",\"single/spearhead_material\":\"spearhead/gold\"}").withTitle("ars_armiger.page.tetra_weapons.page3.title").withText("ars_armiger.page.tetra_weapons.page3.body")).withTextPage("ars_armiger.page.tetra_weapons.page4.body").withPage((IPatchouliPage)new SpotlightPage("tetra:modular_double{\"double/head_right:double/spellstrikefocus_fire\":0,\"double/adze_left_material\":\"adze/gold\",\"double/basic_handle_material\":\"basic_handle/stick\",\"double/butt_right_material\":\"butt/iron\",\"double/handle\":\"double/basic_handle\",\"double/head_left\":\"double/adze_left\",\"double/head_right\":\"double/butt_right\",\"ars_nouveau:caster\":{\"is_hidden\":0,\"current_slot\":0,\"spell_count\":1,\"flavor\":\"\",\"hidden_redipe\":\"\",\"spells\":{\"spell0\":{\"name\":\"\",\"recipe\":{\"size\":3,\"part0\":\"ars_nouveau:glyph_touch\",\"part1\":\"ars_nouveau:glyph_ignite\",\"part2\":\"ars_nouveau:glyph_freeze\"},\"sound\":{\"pitch\":1.0,\"volume\":1.0,\"soundTag\":{}},\"spellColor\":{\"b\":180,\"g\":25,\"r\":255}}}}}").withTitle("ars_armiger.page.tetra_weapons.page5.title").withText("ars_armiger.page.tetra_weapons.page5.body")).withPage((IPatchouliPage)new SpotlightPage("tetra:modular_shield{\"shield/plate:shield/studs/iron\":0,\"shield/plate:shield/trim/iron\":0,\"shield/plate:spellguard\":1,\"shield/basic_grip_material\":\"basic_grip/netherite\",\"shield/boss\":\"shield/sturdy_boss\",\"shield/grip\":\"shield/basic_grip\",\"shield/plate\":\"shield/tower\",\"shield/sturdy_boss_material\":\"sturdy_boss/gold\",\"shield/tower_material\":\"tower/oak\"}").withTitle("ars_armiger.page.tetra_weapons.page6.title").withText("ars_armiger.page.tetra_weapons.page6.body"));
        this.addPage(new PatchouliProvider.PatchouliPage(builder, this.getPath(EQUIPMENT, "tetra_weapons")));
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)patchouliPage.build(), (Path)patchouliPage.path());
        }
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage(root + ".page." + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_())).withPage(recipePage);
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_()));
        this.pages.add(page);
        return page;
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity." + root + "." + familiarHolder.getRegistryName().m_135815_()).withIcon(root + ":" + familiarHolder.getRegistryName().m_135815_()).withTextPage(root + ".familiar_desc." + familiarHolder.getRegistryName().m_135815_()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().m_135815_()));
        this.pages.add(page);
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item.ars_elemental." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage("ars_elemental:tablet_" + ritual.getRegistryName().m_135815_()));
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().m_135815_()));
        this.pages.add(page);
    }

    public void addEnchantmentPage(Enchantment enchantment) {
        PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(RegistryHelper.getRegistryName((Item)Items.f_42690_).toString()).withTextPage(root + ".enchantment_desc." + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_());
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            builder.withPage((IPatchouliPage)new EnchantingPage("ars_nouveau:" + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_() + "_" + i));
        }
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(ENCHANTMENTS, RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_()));
        this.pages.add(page);
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName(root + ".glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage(root + ".glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_()));
        this.pages.add(page);
    }

    public String m_6055_() {
        return "Example Patchouli Datagen";
    }

    public Path getPath(ResourceLocation category, String fileName) {
        return this.generator.m_123916_().resolve("data/" + root + "/patchouli_books/modular/en_us/entries/" + category.m_135815_() + "/" + fileName + ".json");
    }

    ImbuementPage ImbuementPage(ItemLike item) {
        return new ImbuementPage(root + ":imbuement_" + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_());
    }
}

