/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.registry;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.client.ElementalTurretRenderer;
import alexthw.ars_elemental.client.PrismRenderer;
import alexthw.ars_elemental.common.blocks.ElementalTurret;
import alexthw.ars_elemental.common.blocks.EverfullUrnBlock;
import alexthw.ars_elemental.common.blocks.SporeBlossomGround;
import alexthw.ars_elemental.common.blocks.mermaid_block.MermaidRock;
import alexthw.ars_elemental.common.blocks.prism.AccelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.AdvancedPrism;
import alexthw.ars_elemental.common.blocks.prism.ArcPrismLens;
import alexthw.ars_elemental.common.blocks.prism.DecelerationPrismLens;
import alexthw.ars_elemental.common.blocks.prism.HomingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.PiercingPrismLens;
import alexthw.ars_elemental.common.blocks.prism.RainbowPrismLens;
import alexthw.ars_elemental.common.blocks.prism.SpellMirror;
import alexthw.ars_elemental.common.blocks.upstream.AirUpstreamTile;
import alexthw.ars_elemental.common.blocks.upstream.MagmaUpstreamTile;
import alexthw.ars_elemental.common.blocks.upstream.UpstreamBlock;
import alexthw.ars_elemental.common.items.CasterHolder;
import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.common.items.Debugger;
import alexthw.ars_elemental.common.items.FirenandoCharm;
import alexthw.ars_elemental.common.items.NecroEssence;
import alexthw.ars_elemental.common.items.SirenCharm;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.bangles.AirBangles;
import alexthw.ars_elemental.common.items.bangles.BaseBangle;
import alexthw.ars_elemental.common.items.bangles.EarthBangles;
import alexthw.ars_elemental.common.items.bangles.FireBangles;
import alexthw.ars_elemental.common.items.bangles.WaterBangles;
import alexthw.ars_elemental.common.items.caster_tools.ElementalCasterTome;
import alexthw.ars_elemental.common.items.caster_tools.SpellHorn;
import alexthw.ars_elemental.common.items.foci.ElementalFocus;
import alexthw.ars_elemental.common.items.foci.GreaterElementalFocus;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.world.ModWorldgen;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.MagicLeaves;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTree;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ars_elemental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_elemental");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ars_elemental");
    public static final RegistryObject<Block> MERMAID_ROCK;
    public static final RegistryObject<Block> WATER_URN;
    public static final RegistryObject<Block> FLASHING_ARCHWOOD_LOG;
    public static final RegistryObject<Block> FLASHING_ARCHWOOD_LOG_STRIPPED;
    public static final RegistryObject<Block> FLASHING_ARCHWOOD_STRIPPED;
    public static final RegistryObject<Block> FLASHING_ARCHWOOD;
    public static final RegistryObject<Block> FLASHING_SAPLING;
    public static final RegistryObject<Block> FLASHING_LEAVES;
    public static final RegistryObject<Block> FLASHING_POD;
    public static final RegistryObject<Block> POT_FLASHING_SAPLING;
    public static final RegistryObject<Block> GROUND_BLOSSOM;
    public static final RegistryObject<Block> WATER_UPSTREAM_BLOCK;
    public static final RegistryObject<Block> LAVA_UPSTREAM_BLOCK;
    public static final RegistryObject<Block> AIR_UPSTREAM_BLOCK;
    public static final RegistryObject<Block> FIRE_TURRET;
    public static final RegistryObject<Block> WATER_TURRET;
    public static final RegistryObject<Block> AIR_TURRET;
    public static final RegistryObject<Block> EARTH_TURRET;
    public static final RegistryObject<Block> SHAPING_TURRET;
    public static final RegistryObject<Block> ADVANCED_PRISM;
    public static final RegistryObject<Block> SPELL_MIRROR;
    public static final RegistryObject<Item> FIRE_FOCUS;
    public static final RegistryObject<Item> AIR_FOCUS;
    public static final RegistryObject<Item> WATER_FOCUS;
    public static final RegistryObject<Item> EARTH_FOCUS;
    public static final RegistryObject<Item> NECRO_FOCUS;
    public static final RegistryObject<Item> LESSER_FIRE_FOCUS;
    public static final RegistryObject<Item> LESSER_AIR_FOCUS;
    public static final RegistryObject<Item> LESSER_WATER_FOCUS;
    public static final RegistryObject<Item> LESSER_EARTH_FOCUS;
    public static final ArmorSet FIRE_ARMOR;
    public static final ArmorSet AIR_ARMOR;
    public static final ArmorSet EARTH_ARMOR;
    public static final ArmorSet WATER_ARMOR;
    public static final RegistryObject<Item> FIRE_CTOME;
    public static final RegistryObject<Item> AIR_CTOME;
    public static final RegistryObject<Item> WATER_CTOME;
    public static final RegistryObject<Item> EARTH_CTOME;
    public static final RegistryObject<Item> NECRO_CTOME;
    public static final RegistryObject<Item> ENCHANTER_BANGLE;
    public static final RegistryObject<Item> FIRE_BANGLE;
    public static final RegistryObject<Item> WATER_BANGLE;
    public static final RegistryObject<Item> AIR_BANGLE;
    public static final RegistryObject<Item> EARTH_BANGLE;
    public static final RegistryObject<Item> CURIO_BAG;
    public static final RegistryObject<Item> CASTER_BAG;
    public static final RegistryObject<Item> DEBUG_ICON;
    public static final RegistryObject<Item> MARK_OF_MASTERY;
    public static final RegistryObject<Item> HOMING_LENS;
    public static final RegistryObject<Item> ARC_LENS;
    public static final RegistryObject<Item> ACC_LENS;
    public static final RegistryObject<Item> DEC_LENS;
    public static final RegistryObject<Item> PIERCE_LENS;
    public static final RegistryObject<Item> RGB_LENS;
    public static final RegistryObject<Item> ANIMA_ESSENCE;
    public static final RegistryObject<Item> SIREN_SHARDS;
    public static final RegistryObject<Item> SIREN_CHARM;
    public static final RegistryObject<Item> FIRENANDO_CHARM;
    public static final RegistryObject<Item> SPELL_HORN;
    public static FoodProperties FLASHPINE_FOOD;

    static Item.Properties addTabProp() {
        return new Item.Properties().m_41491_(ArsElemental.TAB);
    }

    static Item.Properties FocusProp() {
        return ModItems.addTabProp().m_41487_(1).m_41486_().m_41497_(Rarity.EPIC);
    }

    static Item.Properties UncommonProp() {
        return ModItems.addTabProp().m_41487_(1).m_41497_(Rarity.UNCOMMON);
    }

    public static Item.Properties ArmorProp() {
        return ModItems.addTabProp().m_41497_(Rarity.EPIC);
    }

    static RegistryObject<Block> addBlock(String name, Supplier<Block> blockSupp) {
        RegistryObject block = BLOCKS.register(name, blockSupp);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), ModItems.addTabProp()));
        return block;
    }

    static RegistryObject<Block> addGeckoBlock(String name, Supplier<Block> blockSupp, final String model) {
        RegistryObject block = BLOCKS.register(name, blockSupp);
        ITEMS.register(name, () -> new RendererBlockItem((Block)block.get(), ModItems.addTabProp()){

            @OnlyIn(value=Dist.CLIENT)
            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return () -> ElementalTurretRenderer.getISTER(model);
            }
        });
        return block;
    }

    static BlockBehaviour.Properties blockProps(Material mat, MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)mat, (MaterialColor)color);
    }

    private static Boolean allowsSpawnOnLeaves(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.f_20505_ || entity == EntityType.f_20508_;
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    static {
        FIRE_ARMOR = new ArmorSet("fire", SpellSchools.ELEMENTAL_FIRE);
        AIR_ARMOR = new ArmorSet("air", SpellSchools.ELEMENTAL_AIR);
        EARTH_ARMOR = new ArmorSet("earth", SpellSchools.ELEMENTAL_EARTH);
        WATER_ARMOR = new ArmorSet("aqua", SpellSchools.ELEMENTAL_WATER);
        FLASHPINE_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance(MobEffects.f_19611_, 600), 0.4f).effect(() -> new MobEffectInstance(MobEffects.f_19619_, 600), 0.4f).effect(() -> new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.common.potions.ModPotions.SHOCKED_EFFECT.get(), 600, 0), 0.8f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.LIGHTNING_LURE.get(), 600, 0), 0.2f).m_38765_().m_38767_();
        SIREN_SHARDS = ITEMS.register("siren_shards", () -> new ModItem(ModItems.addTabProp()).withTooltip((Component)Component.m_237115_((String)"tooltip.siren_shards")));
        SIREN_CHARM = ITEMS.register("siren_charm", () -> new SirenCharm(ModItems.addTabProp()));
        FIRENANDO_CHARM = ITEMS.register("firenando_charm", () -> new FirenandoCharm(ModItems.addTabProp().m_41486_()));
        DEBUG_ICON = ITEMS.register("debug", () -> new Debugger(new Item.Properties()));
        MARK_OF_MASTERY = ITEMS.register("mark_of_mastery", () -> new Item(ModItems.addTabProp()));
        ANIMA_ESSENCE = ITEMS.register("anima_essence", () -> new NecroEssence(ModItems.addTabProp()));
        SPELL_HORN = ITEMS.register("spell_horn", () -> new SpellHorn(ModItems.addTabProp()));
        HOMING_LENS = ITEMS.register("homing_prism_lens", () -> new HomingPrismLens(ModItems.addTabProp()));
        ARC_LENS = ITEMS.register("arc_prism_lens", () -> new ArcPrismLens(ModItems.addTabProp()));
        RGB_LENS = ITEMS.register("rainbow_prism_lens", () -> new RainbowPrismLens(ModItems.addTabProp()));
        ACC_LENS = ITEMS.register("acceleration_prism_lens", () -> new AccelerationPrismLens(ModItems.addTabProp()));
        DEC_LENS = ITEMS.register("deceleration_prism_lens", () -> new DecelerationPrismLens(ModItems.addTabProp()));
        PIERCE_LENS = ITEMS.register("piercing_prism_lens", () -> new PiercingPrismLens(ModItems.addTabProp()));
        CURIO_BAG = ITEMS.register("curio_bag", () -> new CurioHolder(ModItems.addTabProp().m_41486_().m_41487_(1)));
        FIRE_FOCUS = ITEMS.register("fire_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_FIRE));
        WATER_FOCUS = ITEMS.register("water_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_WATER));
        AIR_FOCUS = ITEMS.register("air_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_AIR));
        EARTH_FOCUS = ITEMS.register("earth_focus", () -> new GreaterElementalFocus(ModItems.FocusProp(), SpellSchools.ELEMENTAL_EARTH));
        NECRO_FOCUS = ITEMS.register("necrotic_focus", () -> new NecroticFocus(ModItems.FocusProp()));
        LESSER_FIRE_FOCUS = ITEMS.register("lesser_fire_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_FIRE));
        LESSER_WATER_FOCUS = ITEMS.register("lesser_water_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_WATER));
        LESSER_AIR_FOCUS = ITEMS.register("lesser_air_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_AIR));
        LESSER_EARTH_FOCUS = ITEMS.register("lesser_earth_focus", () -> new ElementalFocus(ModItems.UncommonProp(), SpellSchools.ELEMENTAL_EARTH));
        ENCHANTER_BANGLE = ITEMS.register("base_bangle", () -> new BaseBangle(ModItems.addTabProp().m_41487_(1)));
        FIRE_BANGLE = ITEMS.register("fire_bangle", () -> new FireBangles(ModItems.UncommonProp()));
        WATER_BANGLE = ITEMS.register("water_bangle", () -> new WaterBangles(ModItems.UncommonProp()));
        AIR_BANGLE = ITEMS.register("air_bangle", () -> new AirBangles(ModItems.UncommonProp()));
        EARTH_BANGLE = ITEMS.register("earth_bangle", () -> new EarthBangles(ModItems.UncommonProp()));
        CASTER_BAG = ITEMS.register("caster_bag", () -> new CasterHolder(ModItems.addTabProp().m_41486_().m_41487_(1)));
        FIRE_CTOME = ITEMS.register("fire_caster_tome", () -> new ElementalCasterTome(ModItems.addTabProp().m_41487_(1), SpellSchools.ELEMENTAL_FIRE));
        WATER_CTOME = ITEMS.register("water_caster_tome", () -> new ElementalCasterTome(ModItems.addTabProp().m_41487_(1), SpellSchools.ELEMENTAL_WATER));
        AIR_CTOME = ITEMS.register("air_caster_tome", () -> new ElementalCasterTome(ModItems.addTabProp().m_41487_(1), SpellSchools.ELEMENTAL_AIR));
        EARTH_CTOME = ITEMS.register("earth_caster_tome", () -> new ElementalCasterTome(ModItems.addTabProp().m_41487_(1), SpellSchools.ELEMENTAL_EARTH));
        NECRO_CTOME = ITEMS.register("anima_caster_tome", () -> new ElementalCasterTome(ModItems.addTabProp().m_41487_(1), ArsNouveauRegistry.NECROMANCY));
        WATER_URN = ModItems.addBlock("everfull_urn", () -> new EverfullUrnBlock(ModItems.blockProps(Material.f_76313_, MaterialColor.f_76362_).m_60918_(SoundType.f_222471_).m_60955_()));
        MERMAID_ROCK = ModItems.addBlock("mermaid_rock", () -> new MermaidRock(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76415_).m_60918_(SoundType.f_56753_).m_60913_(2.0f, 6.0f).m_60955_().m_60953_(b -> 10)));
        GROUND_BLOSSOM = ModItems.addBlock("spore_blossom_up", () -> new SporeBlossomGround(ModItems.blockProps(Material.f_76300_, MaterialColor.f_76418_).m_60918_(SoundType.f_154665_).m_60955_()));
        WATER_UPSTREAM_BLOCK = ModItems.addBlock("water_upstream", () -> new UpstreamBlock(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76415_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f)));
        LAVA_UPSTREAM_BLOCK = ModItems.addBlock("magma_upstream", () -> new UpstreamBlock(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76364_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f)){

            @Override
            public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
                return new MagmaUpstreamTile(pPos, pState);
            }
        });
        AIR_UPSTREAM_BLOCK = ModItems.addBlock("air_upstream", () -> new UpstreamBlock(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76416_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f)){

            @Override
            public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
                return new AirUpstreamTile(pPos, pState);
            }
        });
        FIRE_TURRET = ModItems.addGeckoBlock("fire_turret", () -> new ElementalTurret(ModItems.blockProps(Material.f_76279_, MaterialColor.f_76364_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f), SpellSchools.ELEMENTAL_FIRE), "fire");
        WATER_TURRET = ModItems.addGeckoBlock("water_turret", () -> new ElementalTurret(ModItems.blockProps(Material.f_76279_, MaterialColor.f_76415_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f), SpellSchools.ELEMENTAL_WATER), "water");
        AIR_TURRET = ModItems.addGeckoBlock("air_turret", () -> new ElementalTurret(ModItems.blockProps(Material.f_76279_, MaterialColor.f_76416_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f), SpellSchools.ELEMENTAL_AIR), "air");
        EARTH_TURRET = ModItems.addGeckoBlock("earth_turret", () -> new ElementalTurret(ModItems.blockProps(Material.f_76279_, MaterialColor.f_76363_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f), SpellSchools.ELEMENTAL_EARTH), "earth");
        SHAPING_TURRET = ModItems.addGeckoBlock("manipulation_turret", () -> new ElementalTurret(ModItems.blockProps(Material.f_76279_, MaterialColor.f_76413_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 6.0f), SpellSchools.MANIPULATION), "manipulation");
        ADVANCED_PRISM = BLOCKS.register("advanced_prism", () -> new AdvancedPrism(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76372_)));
        ITEMS.register("advanced_prism", () -> new RendererBlockItem((Block)ADVANCED_PRISM.get(), ModItems.addTabProp()){

            @OnlyIn(value=Dist.CLIENT)
            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return PrismRenderer::getISTER;
            }
        });
        SPELL_MIRROR = ModItems.addBlock("spell_mirror", () -> new SpellMirror(ModItems.blockProps(Material.f_76278_, MaterialColor.f_76372_)));
        FLASHING_SAPLING = ModItems.addBlock("yellow_archwood_sapling", () -> new SaplingBlock((AbstractTreeGrower)new MagicTree(() -> (Holder)ModWorldgen.FLASHING_TREE_SAPLING.getHolder().get()), BlockRegistry.SAP_PROP));
        FLASHING_LEAVES = ModItems.addBlock("yellow_archwood_leaves", () -> new MagicLeaves(ModItems.blockProps(Material.f_76274_, MaterialColor.f_76416_).m_60953_(b -> 8).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(ModItems::allowsSpawnOnLeaves).m_60960_(ModItems::isntSolid).m_60971_(ModItems::isntSolid)));
        FLASHING_ARCHWOOD_LOG_STRIPPED = ModItems.addBlock("stripped_yellow_archwood_log", () -> new RotatedPillarBlock(BlockRegistry.LOG_PROP.m_155949_(MaterialColor.f_76416_).m_60953_(b -> 6)));
        FLASHING_ARCHWOOD_STRIPPED = ModItems.addBlock("stripped_yellow_archwood", () -> new RotatedPillarBlock(BlockRegistry.LOG_PROP.m_155949_(MaterialColor.f_76416_).m_60953_(b -> 6)));
        FLASHING_ARCHWOOD_LOG = ModItems.addBlock("yellow_archwood_log", () -> new StrippableLog(BlockRegistry.LOG_PROP.m_155949_(MaterialColor.f_76416_).m_60953_(b -> 8), FLASHING_ARCHWOOD_LOG_STRIPPED));
        FLASHING_ARCHWOOD = ModItems.addBlock("yellow_archwood", () -> new StrippableLog(BlockRegistry.LOG_PROP.m_155949_(MaterialColor.f_76416_).m_60953_(b -> 8), FLASHING_ARCHWOOD_STRIPPED));
        FLASHING_POD = BLOCKS.register("flashpine_pod", () -> new ArchfruitPod(FLASHING_ARCHWOOD_LOG));
        ITEMS.register("flashpine_pod", () -> new ItemNameBlockItem((Block)FLASHING_POD.get(), ModItems.addTabProp().m_41489_(FLASHPINE_FOOD)));
        POT_FLASHING_SAPLING = BLOCKS.register("potted_yellow_archwood_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, FLASHING_SAPLING, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_()));
    }
}

