/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectSpores
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectSpores INSTANCE = new EffectSpores();

    public EffectSpores() {
        super("poison_spores", "Spores");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level level, @Nonnull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block7: {
            block6: {
                Entity entity = rayTraceResult.m_82443_();
                if (!(entity instanceof LivingEntity)) break block6;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block7;
            }
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 3.0 + spellStats.getAoeMultiplier();
        int effectSec = (int)((double)((Integer)this.POTION_TIME.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier());
        if (!this.canDamage(shooter, spellStats, spellContext, resolver, (Entity)livingEntity)) {
            return;
        }
        this.damage(vec, world, shooter, spellStats, damage, effectSec, livingEntity, spellContext, resolver);
        for (LivingEntity e : world.m_45976_(LivingEntity.class, new AABB(livingEntity.m_20182_().m_82520_(range, range, range), livingEntity.m_20182_().m_82492_(range, range, range)))) {
            if (e.equals((Object)livingEntity) || e.equals((Object)shooter)) continue;
            if (this.canDamage(e, spellStats, spellContext, resolver, (Entity)e)) {
                vec = e.m_20182_();
                this.damage(vec, world, shooter, spellStats, damage, effectSec, e, spellContext, resolver);
                continue;
            }
            e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20 * effectSec, (int)spellStats.getAmpMultiplier()));
        }
    }

    public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        LivingEntity living;
        return !(!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).m_21223_() <= 0.0f || !living.m_21023_(MobEffects.f_19614_) && !living.m_21023_(MobEffects.f_19612_));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void damage(Vec3 vec, ServerLevel world, @Nonnull LivingEntity shooter, SpellStats stats, float damage, int snareTime, LivingEntity livingEntity, SpellContext spellContext, SpellResolver resolver) {
        EntityDamageSource damageSource = new EntityDamageSource("poison", (Entity)shooter);
        damageSource.m_19389_();
        this.attemptDamage((Level)world, shooter, stats, spellContext, resolver, (Entity)livingEntity, (DamageSource)damageSource, damage);
        world.m_8767_((ParticleOptions)ParticleTypes.f_175833_, vec.f_82479_, vec.f_82480_ + 0.5, vec.f_82481_, 50, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.5);
        if (livingEntity.m_21224_() && world.m_213780_().m_188503_(100) < 5) {
            SpellSchool spellSchool;
            BlockEntity blockEntity = spellContext.castingTile;
            if (blockEntity instanceof ElementalSpellTurretTile) {
                ElementalSpellTurretTile turret = (ElementalSpellTurretTile)blockEntity;
                spellSchool = turret.getSchool();
            } else {
                spellSchool = ISchoolFocus.hasFocus((Entity)shooter);
            }
            if (spellSchool == SpellSchools.ELEMENTAL_EARTH) {
                BlockPos feet = livingEntity.m_20097_();
                Material underfoot = world.m_8055_(feet).m_60767_();
                Block blossom = (Block)ModItems.GROUND_BLOSSOM.get();
                if (underfoot != Material.f_76314_ && underfoot != Material.f_76315_ && underfoot != Material.f_164530_) {
                    if (underfoot != Material.f_76274_) return;
                }
                if (!world.m_8055_(feet.m_7494_()).m_60795_()) return;
                world.m_46597_(feet.m_7494_(), ((Block)ModItems.GROUND_BLOSSOM.get()).m_49966_());
                if (!(shooter instanceof ServerPlayer)) return;
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                if (serverPlayer instanceof FakePlayer) return;
                ModAdvTriggers.BLOSSOM.m_222618_(serverPlayer);
                return;
            }
        }
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 20 * snareTime));
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 2.5);
        this.addPotionConfig(builder, 10);
        this.addExtendTimeConfig(builder, 3);
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.getDefaultAugmentLimits(defaults);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        return defaults;
    }

    public int getDefaultManaCost() {
        return 30;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE});
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

