/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.network.RayEffectPacket;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EffectDischarge
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectDischarge INSTANCE = new EffectDischarge();

    public EffectDischarge() {
        super("discharge", "Discharge");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block8: {
            block7: {
                Entity entity = rayTraceResult.m_82443_();
                if (!(entity instanceof LivingEntity)) break block7;
                livingEntity = (LivingEntity)entity;
                if (world instanceof ServerLevel) break block8;
            }
            return;
        }
        ServerLevel level = (ServerLevel)world;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 4.0 + spellStats.getAoeMultiplier();
        DamageSource source = this.buildDamageSource(world, shooter);
        if (livingEntity.m_21023_((MobEffect)ModPotions.SHOCKED_EFFECT.get()) || livingEntity.m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.LIGHTNING_LURE.get())) {
            if (livingEntity.m_21023_((MobEffect)alexthw.ars_elemental.registry.ModPotions.LIGHTNING_LURE.get())) {
                damage = (float)((double)damage * 1.3);
                livingEntity.m_21195_((MobEffect)alexthw.ars_elemental.registry.ModPotions.LIGHTNING_LURE.get());
            }
            for (ItemStack i : livingEntity.m_6168_()) {
                Optional energyStorage;
                LazyOptional lazyEnergyStorage = i.getCapability(ForgeCapabilities.ENERGY);
                if (!lazyEnergyStorage.isPresent() || !(energyStorage = lazyEnergyStorage.resolve()).isPresent()) continue;
                ((IEnergyStorage)energyStorage.get()).extractEnergy((int)((double)((IEnergyStorage)energyStorage.get()).getEnergyStored() * 0.25), false);
                damage = (float)((double)damage * 1.1);
            }
            for (LivingEntity entity : world.m_6443_(LivingEntity.class, new AABB(livingEntity.m_20183_()).m_82400_(range), e -> !e.equals((Object)shooter))) {
                this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)entity, source, damage);
                this.applyConfigPotion(entity, (MobEffect)ModPotions.SHOCKED_EFFECT.get(), spellStats);
                RayEffectPacket.send(world, new ParticleColor(225, 200, 50), livingEntity.m_20182_(), entity.m_20182_());
            }
        }
    }

    public void applyPotion(LivingEntity entity, MobEffect potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)Math.min(stats.getAmpMultiplier(), 5.0);
        entity.m_7292_(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world)) : shooter;
        return new EntityDamageSource(DamageSource.f_19306_.m_19385_(), (Entity)shooter);
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 7.0);
        this.addAmpConfig(builder, 3.0);
        this.addPotionConfig(builder, 15);
        this.addExtendTimeConfig(builder, 5);
    }

    public int getDefaultManaCost() {
        return 40;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    protected Map<ResourceLocation, Integer> getDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.getDefaultAugmentLimits(defaults);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        return defaults;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE});
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return Set.of(SpellSchools.ELEMENTAL_AIR);
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 15 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 5 : (Integer)this.EXTEND_TIME.get();
    }
}

