/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.compiler.Frontmatter;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.compiler.TagCompiler;
import appeng.client.guidebook.compiler.TagCompilers;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytImage;
import appeng.client.guidebook.document.block.LytList;
import appeng.client.guidebook.document.block.LytListItem;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.block.LytThematicBreak;
import appeng.client.guidebook.document.block.table.LytTable;
import appeng.client.guidebook.document.block.table.LytTableCell;
import appeng.client.guidebook.document.block.table.LytTableRow;
import appeng.client.guidebook.document.flow.LytFlowBreak;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowInlineBlock;
import appeng.client.guidebook.document.flow.LytFlowLink;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.document.flow.LytFlowText;
import appeng.client.guidebook.document.interaction.TextTooltip;
import appeng.client.guidebook.indices.PageIndex;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.style.TextAlignment;
import appeng.client.guidebook.style.WhiteSpaceMode;
import appeng.libs.mdast.MdAst;
import appeng.libs.mdast.MdAstYamlFrontmatter;
import appeng.libs.mdast.MdastOptions;
import appeng.libs.mdast.YamlFrontmatterExtension;
import appeng.libs.mdast.gfm.GfmTableMdastExtension;
import appeng.libs.mdast.gfm.model.GfmTable;
import appeng.libs.mdast.gfm.model.GfmTableRow;
import appeng.libs.mdast.mdx.MdxMdastExtension;
import appeng.libs.mdast.mdx.model.MdxJsxFlowElement;
import appeng.libs.mdast.mdx.model.MdxJsxTextElement;
import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.mdast.model.MdAstBreak;
import appeng.libs.mdast.model.MdAstCode;
import appeng.libs.mdast.model.MdAstEmphasis;
import appeng.libs.mdast.model.MdAstHeading;
import appeng.libs.mdast.model.MdAstImage;
import appeng.libs.mdast.model.MdAstInlineCode;
import appeng.libs.mdast.model.MdAstLink;
import appeng.libs.mdast.model.MdAstList;
import appeng.libs.mdast.model.MdAstListContent;
import appeng.libs.mdast.model.MdAstListItem;
import appeng.libs.mdast.model.MdAstNode;
import appeng.libs.mdast.model.MdAstParagraph;
import appeng.libs.mdast.model.MdAstParent;
import appeng.libs.mdast.model.MdAstPhrasingContent;
import appeng.libs.mdast.model.MdAstPosition;
import appeng.libs.mdast.model.MdAstRoot;
import appeng.libs.mdast.model.MdAstStrong;
import appeng.libs.mdast.model.MdAstText;
import appeng.libs.mdast.model.MdAstThematicBreak;
import appeng.libs.mdx.MdxSyntax;
import appeng.libs.micromark.extensions.YamlFrontmatterSyntax;
import appeng.libs.micromark.extensions.gfm.GfmTableSyntax;
import appeng.libs.unist.UnistNode;
import appeng.libs.unist.UnistPoint;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class PageCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageCompiler.class);
    private static final int DEFAULT_ELEMENT_SPACING = 5;
    private final PageCollection pages;
    private final String sourcePack;
    private final ResourceLocation id;
    private final String pageContent;

    public PageCompiler(PageCollection pages, String sourcePack, ResourceLocation id, String pageContent) {
        this.pages = pages;
        this.sourcePack = sourcePack;
        this.id = id;
        this.pageContent = pageContent;
    }

    public static ParsedGuidePage parse(String sourcePack, ResourceLocation id, InputStream in) throws IOException {
        String pageContent = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        MdastOptions options = new MdastOptions().withSyntaxExtension(MdxSyntax.INSTANCE).withSyntaxExtension(YamlFrontmatterSyntax.INSTANCE).withSyntaxExtension(GfmTableSyntax.INSTANCE).withMdastExtension(MdxMdastExtension.INSTANCE).withMdastExtension(YamlFrontmatterExtension.INSTANCE).withMdastExtension(GfmTableMdastExtension.INSTANCE);
        MdAstRoot astRoot = MdAst.fromMarkdown(pageContent, options);
        Frontmatter frontmatter = PageCompiler.parseFrontmatter(id, astRoot);
        return new ParsedGuidePage(sourcePack, id, pageContent, astRoot, frontmatter);
    }

    public static GuidePage compile(PageCollection pages, ParsedGuidePage parsedPage) {
        LytDocument document = new PageCompiler(pages, parsedPage.sourcePack, parsedPage.id, parsedPage.source).compile(parsedPage.astRoot);
        return new GuidePage(parsedPage.sourcePack, parsedPage.id, document);
    }

    private LytDocument compile(MdAstRoot root) {
        LytDocument document = new LytDocument();
        this.compileBlockContext(root, document);
        return document;
    }

    private static Frontmatter parseFrontmatter(ResourceLocation pageId, MdAstRoot root) {
        Frontmatter result = null;
        for (MdAstAnyContent child : root.children()) {
            if (!(child instanceof MdAstYamlFrontmatter)) continue;
            MdAstYamlFrontmatter frontmatter = (MdAstYamlFrontmatter)child;
            if (result != null) {
                LOGGER.error("Found more than one frontmatter!");
                continue;
            }
            try {
                result = Frontmatter.parse(pageId, frontmatter.value);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse frontmatter for page {}", (Object)pageId, (Object)e);
                break;
            }
        }
        return Objects.requireNonNullElse(result, new Frontmatter(null, Map.of()));
    }

    public void compileBlockContext(MdAstParent<?> markdownParent, LytBlockContainer layoutParent) {
        LytThematicBreak previousLayoutChild = null;
        for (MdAstAnyContent child : markdownParent.children()) {
            LytBlock layoutChild;
            if (child instanceof MdAstThematicBreak) {
                layoutChild = new LytThematicBreak();
            } else if (child instanceof MdAstList) {
                MdAstList astList = (MdAstList)child;
                layoutChild = this.compileList(astList);
            } else if (child instanceof MdAstCode) {
                MdAstCode astCode = (MdAstCode)child;
                paragraph = new LytParagraph();
                paragraph.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
                paragraph.setMarginLeft(5);
                paragraph.appendText(astCode.value);
                layoutChild = paragraph;
            } else if (child instanceof MdAstHeading) {
                MdAstHeading astHeading = (MdAstHeading)child;
                LytHeading heading = new LytHeading();
                heading.setDepth(astHeading.depth);
                this.compileFlowContext(astHeading, heading);
                layoutChild = heading;
            } else if (child instanceof MdAstParagraph) {
                MdAstParagraph astParagraph = (MdAstParagraph)child;
                paragraph = new LytParagraph();
                this.compileFlowContext(astParagraph, paragraph);
                paragraph.setMarginTop(5);
                paragraph.setMarginBottom(5);
                layoutChild = paragraph;
            } else if (child instanceof MdAstYamlFrontmatter) {
                layoutChild = null;
            } else if (child instanceof GfmTable) {
                GfmTable astTable = (GfmTable)child;
                layoutChild = this.compileTable(astTable);
            } else if (child instanceof MdxJsxFlowElement) {
                MdxJsxFlowElement el = (MdxJsxFlowElement)child;
                TagCompiler compiler = TagCompilers.get(el.name());
                if (compiler == null) {
                    layoutChild = this.createErrorBlock("Unhandled MDX element in block context", (MdAstNode)((Object)child));
                } else {
                    layoutChild = null;
                    compiler.compileBlockContext(this, layoutParent, el);
                }
            } else if (child instanceof MdAstPhrasingContent) {
                MdAstPhrasingContent phrasingContent = (MdAstPhrasingContent)child;
                if (previousLayoutChild instanceof LytParagraph) {
                    paragraph = (LytParagraph)((Object)previousLayoutChild);
                    this.compileFlowContent(paragraph, phrasingContent);
                    continue;
                }
                LytParagraph paragraph = new LytParagraph();
                this.compileFlowContent(paragraph, phrasingContent);
                layoutChild = paragraph;
            } else {
                layoutChild = this.createErrorBlock("Unhandled Markdown node in block context", (MdAstNode)((Object)child));
            }
            if (layoutChild != null) {
                layoutParent.append(layoutChild);
            }
            previousLayoutChild = layoutChild;
        }
    }

    private LytList compileList(MdAstList astList) {
        LytList list = new LytList(astList.ordered, astList.start);
        for (MdAstListContent listContent : astList.children()) {
            if (listContent instanceof MdAstListItem) {
                LytNode firstChild;
                MdAstListItem astListItem = (MdAstListItem)listContent;
                LytListItem listItem = new LytListItem();
                this.compileBlockContext(astListItem, listItem);
                List<? extends LytNode> children = listItem.getChildren();
                if (!children.isEmpty() && (firstChild = children.get(0)) instanceof LytBlock) {
                    LytBlock firstBlock = (LytBlock)firstChild;
                    firstBlock.setMarginTop(0);
                    firstBlock.setMarginBottom(0);
                }
                list.append(listItem);
                continue;
            }
            list.append(this.createErrorBlock("Cannot handle list content", (MdAstNode)((Object)listContent)));
        }
        return list;
    }

    private LytBlock compileTable(GfmTable astTable) {
        LytTable table = new LytTable();
        table.setMarginBottom(5);
        boolean firstRow = true;
        for (GfmTableRow astRow : astTable.children()) {
            LytTableRow row = table.appendRow();
            if (firstRow) {
                row.modifyStyle(style -> style.bold(true));
                firstRow = false;
            }
            List astCells = astRow.children();
            for (int i = 0; i < astCells.size(); ++i) {
                LytTableCell cell = row.appendCell();
                if (astTable.align != null && i < astTable.align.size()) {
                    switch (astTable.align.get(i)) {
                        case CENTER: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.CENTER));
                            break;
                        }
                        case RIGHT: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.RIGHT));
                        }
                    }
                }
                this.compileBlockContext((MdAstParent)astCells.get(i), cell);
            }
        }
        return table;
    }

    public void compileComponentToFlow(FormattedText formattedText, LytFlowParent layoutParent) {
        formattedText.m_7451_((style, text) -> {
            if (style.m_131179_()) {
                layoutParent.appendText(text);
            } else {
                LytFlowSpan span = new LytFlowSpan();
                span.appendText(text);
                layoutParent.append(span);
            }
            return Optional.empty();
        }, Style.f_131099_);
    }

    public void compileFlowContext(MdAstParent<?> markdownParent, LytFlowParent layoutParent) {
        for (MdAstAnyContent child : markdownParent.children()) {
            this.compileFlowContent(layoutParent, child);
        }
    }

    private void compileFlowContent(LytFlowParent layoutParent, MdAstAnyContent content) {
        LytFlowContent layoutChild;
        if (content instanceof MdAstText) {
            MdAstText astText = (MdAstText)content;
            LytFlowText text = new LytFlowText();
            text.setText(astText.value);
            layoutChild = text;
        } else if (content instanceof MdAstInlineCode) {
            MdAstInlineCode astCode = (MdAstInlineCode)content;
            LytFlowText text = new LytFlowText();
            text.setText(astCode.value);
            text.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
            layoutChild = text;
        } else if (content instanceof MdAstStrong) {
            MdAstStrong astStrong = (MdAstStrong)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.bold(true));
            this.compileFlowContext(astStrong, span);
            layoutChild = span;
        } else if (content instanceof MdAstEmphasis) {
            MdAstEmphasis astEmphasis = (MdAstEmphasis)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.italic(true));
            this.compileFlowContext(astEmphasis, span);
            layoutChild = span;
        } else if (content instanceof MdAstBreak) {
            layoutChild = new LytFlowBreak();
        } else if (content instanceof MdAstLink) {
            MdAstLink astLink = (MdAstLink)content;
            layoutChild = this.compileLink(astLink);
        } else if (content instanceof MdAstImage) {
            MdAstImage astImage = (MdAstImage)content;
            LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
            inlineBlock.setBlock(this.compileImage(astImage));
            layoutChild = inlineBlock;
        } else if (content instanceof MdxJsxTextElement) {
            MdxJsxTextElement el = (MdxJsxTextElement)content;
            TagCompiler compiler = TagCompilers.get(el.name());
            if (compiler == null) {
                layoutChild = this.createErrorFlowContent("Unhandled MDX element in flow context", (MdAstNode)((Object)content));
            } else {
                layoutChild = null;
                compiler.compileFlowContext(this, layoutParent, el);
            }
        } else {
            layoutChild = this.createErrorFlowContent("Unhandled Markdown node in flow context", (MdAstNode)((Object)content));
        }
        if (layoutChild != null) {
            layoutParent.append(layoutChild);
        }
    }

    private LytFlowContent compileLink(MdAstLink astLink) {
        URI uri;
        LytFlowLink link = new LytFlowLink();
        if (astLink.title != null && !astLink.title.isEmpty()) {
            link.setTooltip(new TextTooltip(astLink.title));
        }
        if ((uri = URI.create(astLink.url)).isAbsolute()) {
            link.setClickCallback(screen -> {
                Minecraft mc = Minecraft.m_91087_();
                mc.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
                    if (yes) {
                        Util.m_137581_().m_137648_(uri);
                    }
                    mc.m_91152_((Screen)screen);
                }, astLink.url, false));
            });
        } else {
            ResourceLocation pageId;
            try {
                pageId = IdUtils.resolveLink(uri.getPath(), this.id);
            }
            catch (ResourceLocationException ignored) {
                return this.createErrorFlowContent("Invalid page link", astLink);
            }
            if (!this.pages.pageExists(pageId)) {
                LOGGER.error("Broken link to page '{}' in page {}", (Object)astLink.url, (Object)this.id);
            } else {
                PageAnchor anchor = new PageAnchor(pageId, uri.getFragment());
                link.setClickCallback(screen -> screen.navigateTo(anchor));
            }
        }
        this.compileFlowContext(astLink, link);
        return link;
    }

    @NotNull
    private LytImage compileImage(MdAstImage astImage) {
        LytImage image = new LytImage();
        image.setTitle(astImage.title);
        image.setAlt(astImage.alt);
        try {
            ResourceLocation imageId = IdUtils.resolveLink(astImage.url, this.id);
            byte[] imageContent = this.pages.loadAsset(imageId);
            if (imageContent == null) {
                LOGGER.error("Couldn't find image {}", (Object)astImage.url);
                image.setTitle("Missing image: " + astImage.url);
            }
            image.setImage(imageId, imageContent);
        }
        catch (ResourceLocationException e) {
            LOGGER.error("Invalid image id: {}", (Object)astImage.url);
            image.setTitle("Invalid image URL: " + astImage.url);
        }
        return image;
    }

    public LytBlock createErrorBlock(String text, UnistNode child) {
        LytParagraph paragraph = new LytParagraph();
        paragraph.append(this.createErrorFlowContent(text, child));
        return paragraph;
    }

    public LytFlowContent createErrorFlowContent(String text, UnistNode child) {
        LytFlowSpan span = new LytFlowSpan();
        span.modifyStyle(style -> style.color(new ColorRef(-65536)).whiteSpace(WhiteSpaceMode.PRE));
        UnistPoint pos = child.position().start();
        int startOfLine = this.pageContent.lastIndexOf(10, pos.offset()) + 1;
        int endOfLine = this.pageContent.indexOf(10, pos.offset() + 1);
        if (endOfLine == -1) {
            endOfLine = this.pageContent.length();
        }
        String line = this.pageContent.substring(startOfLine, endOfLine);
        text = (String)text + " " + child.type() + " (" + MdAstPosition.stringify(pos) + ")";
        span.appendText((String)text);
        span.appendBreak();
        span.appendText(line);
        span.appendBreak();
        span.appendText("~".repeat(pos.column() - 1) + "^");
        span.appendBreak();
        LOGGER.warn("{}\n{}\n{}\n", new Object[]{text, line, "~".repeat(pos.column() - 1) + "^"});
        return span;
    }

    public ResourceLocation resolveId(String idText) {
        return IdUtils.resolveId(idText, this.id.m_135827_());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public PageCollection getPageCollection() {
        return this.pages;
    }

    public byte[] loadAsset(ResourceLocation imageId) {
        return this.pages.loadAsset(imageId);
    }

    public <T extends PageIndex> T getIndex(Class<T> clazz) {
        return this.pages.getIndex(clazz);
    }
}

