/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.builder;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.allthemods.alltheores.datagen.RecipeException;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ShapedRawBuilder {
    private final String criteriaName;
    private final InventoryChangeTrigger.TriggerInstance criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> raw;

    public ShapedRawBuilder(TagKey<Item> raw) {
        this.raw = raw;
        this.criteriaName = String.format("has_raw_%s", raw);
        ItemPredicate predicate = ItemPredicate.Builder.m_45068_().m_204145_(raw).m_45077_();
        this.criterion = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedRawBuilder builder(TagKey<Item> raw) {
        return new ShapedRawBuilder(raw);
    }

    public ShapedRawBuilder setRaw(RegistryObject<Item> object) {
        this.pieces.put(Slot.RAW, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.m_176498_(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.RAW)).map(this::raw_block).map(this::addCriterionRaw).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)provider).m_126145_("alltheores");
    }

    private ShapedRecipeBuilder addCriterionRaw(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.raw).m_126132_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder raw_block(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("aaa").m_126130_("aaa");
    }

    public static enum Slot {
        RAW;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

