/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.fusion;

import com.smashingmods.alchemistry.datagen.recipe.fusion.FusionRecipeResult;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FusionRecipeBuilder
implements RecipeBuilder {
    private String group;
    private final ElementItem input1;
    private final ElementItem input2;
    private final ItemStack output;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public FusionRecipeBuilder(ElementItem pInput1, ElementItem pInput2, ElementItem pOutput) {
        this.input1 = pInput1;
        this.input2 = pInput2;
        this.output = new ItemStack((ItemLike)pOutput);
    }

    public static FusionRecipeBuilder createRecipe(ElementItem pInput1, ElementItem pInput2, ElementItem pOutput) {
        return new FusionRecipeBuilder(pInput1, pInput2, pOutput);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)new ResourceLocation("alchemistry", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_())).m_135815_()))).m_138360_(RequirementsStrategy.f_15979_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        String input1String = String.format("%s%s", this.input1.getAtomicNumber(), Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.input1)).m_135815_());
        String input2String = String.format("%s%s", this.input2.getAtomicNumber(), Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.input2)).m_135815_());
        String outputString = String.format("%s%s", ((ElementItem)this.output.m_41720_()).getAtomicNumber(), Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_())).m_135815_());
        ResourceLocation recipeId = new ResourceLocation("alchemistry", String.format("fusion/%s_and_%s_to_%s", input1String, input2String, outputString));
        ResourceLocation advancementId = new ResourceLocation("alchemistry", String.format("recipes/fusion/%s", pRecipeId.m_135815_()));
        pFinishedRecipeConsumer.accept(new FusionRecipeResult(this.group, this.advancementBuilder, recipeId, advancementId, this.input1, this.input2, this.output));
    }
}

