/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.combiner;

import com.smashingmods.alchemistry.common.block.combiner.CombinerBlockEntity;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingMenu;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;

public class CombinerMenu
extends AbstractProcessingMenu {
    private final Level level;
    private final CombinerBlockEntity blockEntity;
    private final LinkedList<CombinerRecipe> displayedRecipes = new LinkedList();

    public CombinerMenu(int pContainerId, Inventory pInventory, FriendlyByteBuf pBuffer) {
        this(pContainerId, pInventory, Objects.requireNonNull(pInventory.f_35978_.f_19853_.m_7702_(pBuffer.m_130135_())));
    }

    protected CombinerMenu(int pContainerId, Inventory pInventory, BlockEntity pBlockEntity) {
        super((MenuType)MenuRegistry.COMBINER_MENU.get(), pContainerId, pInventory, pBlockEntity, 4, 1);
        this.level = pInventory.f_35978_.m_9236_();
        this.blockEntity = (CombinerBlockEntity)pBlockEntity;
        ProcessingSlotHandler inputHandler = this.blockEntity.getInputHandler();
        ProcessingSlotHandler outputHandler = this.blockEntity.getOutputHandler();
        this.setupRecipeList();
        this.addSlots(SlotItemHandler::new, inputHandler, 2, 2, 0, inputHandler.getSlots(), 48, 22);
        this.addSlots(SlotItemHandler::new, outputHandler, 1, 1, 0, outputHandler.getSlots(), 120, 31);
    }

    public boolean m_6875_(Player pPlayer) {
        Objects.requireNonNull(this.getBlockEntity().m_58904_());
        return CombinerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)BlockRegistry.COMBINER.get()));
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        return !this.getBlockEntity().isRecipeLocked() && this.isValidRecipeIndex(pId);
    }

    private boolean isValidRecipeIndex(int pSlot) {
        return pSlot >= 0 && pSlot < this.displayedRecipes.size();
    }

    private void setupRecipeList() {
        if (this.displayedRecipes.isEmpty()) {
            this.resetDisplayedRecipes();
        }
    }

    public void resetDisplayedRecipes() {
        this.displayedRecipes.clear();
        this.displayedRecipes.addAll(RecipeRegistry.getCombinerRecipes(this.level));
    }
}

