/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.block.liquifier.LiquifierBlockEntity;
import com.smashingmods.alchemistry.common.block.liquifier.LiquifierMenu;
import com.smashingmods.alchemistry.common.network.jei.TransferUtils;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class LiquifierTransferPacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final IngredientStack input;
    private final boolean maxTransfer;

    public LiquifierTransferPacket(BlockPos pBlockPos, IngredientStack pInput, boolean pMaxTransfer) {
        this.blockPos = pBlockPos;
        this.input = pInput;
        this.maxTransfer = pMaxTransfer;
    }

    public LiquifierTransferPacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.input = IngredientStack.fromNetwork((FriendlyByteBuf)pBuffer);
        this.maxTransfer = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        this.input.toNetwork(pBuffer);
        pBuffer.writeBoolean(this.maxTransfer);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        LiquifierBlockEntity blockEntity = (LiquifierBlockEntity)player.m_9236_().m_7702_(this.blockPos);
        Objects.requireNonNull(blockEntity);
        ProcessingSlotHandler inputHandler = blockEntity.getInputHandler();
        Inventory inventory = player.m_150109_();
        RecipeRegistry.getLiquifierRecipe(recipe -> Arrays.stream(recipe.getInput().getIngredient().m_43908_()).allMatch((Predicate<ItemStack>)this.input.getIngredient()), (Level)player.m_9236_()).ifPresent(recipe -> {
            boolean canTransfer;
            LiquifierRecipe recipeCopy = recipe.copy();
            inputHandler.emptyToInventory(inventory);
            ItemStack inventoryInput = TransferUtils.matchIngredientToItemStack((NonNullList<ItemStack>)inventory.f_35974_, recipeCopy.getInput());
            ItemStack recipeInput = new ItemStack((ItemLike)inventoryInput.m_41720_(), recipeCopy.getInput().getCount());
            boolean creative = player.f_8941_.m_9295_();
            boolean bl = canTransfer = (!inventoryInput.m_41619_() || creative) && inputHandler.isEmpty() && blockEntity.getFluidStorage().isEmpty();
            if (canTransfer) {
                if (creative) {
                    ItemStack creativeInput = new ItemStack((ItemLike)recipeCopy.getInput().getIngredient().m_43908_()[0].m_41720_(), recipeCopy.getInput().getCount());
                    int maxOperations = TransferUtils.getMaxOperations(creativeInput, this.maxTransfer);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)creativeInput.m_41720_(), recipeCopy.getInput().getCount() * maxOperations));
                } else {
                    int slot = inventory.m_36030_(inventoryInput);
                    int maxOperations = TransferUtils.getMaxOperations(recipeInput, inventory.m_8020_(slot), this.maxTransfer, false);
                    inventory.m_7407_(slot, recipeCopy.getInput().getCount() * maxOperations);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeInput.m_41720_(), recipeCopy.getInput().getCount() * maxOperations));
                }
                blockEntity.setProgress(0);
                blockEntity.setRecipe(recipe);
            }
        });
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<LiquifierMenu, LiquifierRecipe> {
        public Class<LiquifierMenu> getContainerClass() {
            return LiquifierMenu.class;
        }

        public Optional<MenuType<LiquifierMenu>> getMenuType() {
            return Optional.of((MenuType)MenuRegistry.LIQUIFIER_MENU.get());
        }

        public RecipeType<LiquifierRecipe> getRecipeType() {
            return RecipeTypes.LIQUIFIER;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(LiquifierMenu pContainer, LiquifierRecipe pRecipe, IRecipeSlotsView pRecipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
            if (pDoTransfer) {
                pContainer.getBlockEntity().setRecipe((AbstractProcessingRecipe)pRecipe);
                Alchemistry.PACKET_HANDLER.sendToServer(new LiquifierTransferPacket(pContainer.getBlockEntity().m_58899_(), pRecipe.getInput(), pMaxTransfer));
            }
            return null;
        }
    }
}

