/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.block.compactor.CompactorBlockEntity;
import com.smashingmods.alchemistry.common.block.compactor.CompactorMenu;
import com.smashingmods.alchemistry.common.network.jei.TransferUtils;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class CompactorTransferPacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final ItemStack output;
    private final boolean maxTransfer;

    public CompactorTransferPacket(BlockPos pBlockPos, ItemStack pOutput, boolean pMaxTransfer) {
        this.blockPos = pBlockPos;
        this.output = pOutput;
        this.maxTransfer = pMaxTransfer;
    }

    public CompactorTransferPacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.output = pBuffer.m_130267_();
        this.maxTransfer = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        pBuffer.m_130055_(this.output);
        pBuffer.writeBoolean(this.maxTransfer);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        CompactorBlockEntity blockEntity = (CompactorBlockEntity)player.m_9236_().m_7702_(this.blockPos);
        Objects.requireNonNull(blockEntity);
        ProcessingSlotHandler inputHandler = blockEntity.getInputHandler();
        ProcessingSlotHandler outputHandler = blockEntity.getOutputHandler();
        Inventory inventory = player.m_150109_();
        RecipeRegistry.getCompactorRecipe(recipe -> ItemStack.m_150942_((ItemStack)recipe.getOutput(), (ItemStack)this.output), (Level)player.m_9236_()).ifPresent(recipe -> {
            boolean canTransfer;
            CompactorRecipe recipeCopy = recipe.copy();
            inputHandler.emptyToInventory(inventory);
            outputHandler.emptyToInventory(inventory);
            ItemStack inventoryInput = TransferUtils.matchIngredientToItemStack((NonNullList<ItemStack>)inventory.f_35974_, recipeCopy.getInput());
            ItemStack recipeInput = new ItemStack((ItemLike)inventoryInput.m_41720_(), recipeCopy.getInput().getCount());
            boolean creative = player.f_8941_.m_9295_();
            boolean bl = canTransfer = (!inventoryInput.m_41619_() || creative) && inputHandler.isEmpty() && outputHandler.isEmpty();
            if (canTransfer) {
                if (creative) {
                    ItemStack creativeInput = new ItemStack((ItemLike)recipeCopy.getInput().getIngredient().m_43908_()[0].m_41720_(), recipeCopy.getInput().getCount());
                    int maxOperations = TransferUtils.getMaxOperations(creativeInput, this.maxTransfer);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)creativeInput.m_41720_(), recipeCopy.getInput().getCount() * maxOperations));
                } else {
                    int slot = inventory.m_36030_(inventoryInput);
                    int maxOperations = TransferUtils.getMaxOperations(recipeInput, inventory.m_8020_(slot), this.maxTransfer, false);
                    inventory.m_7407_(slot, recipeCopy.getInput().getCount() * maxOperations);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeInput.m_41720_(), recipeCopy.getInput().getCount() * maxOperations));
                }
                blockEntity.setProgress(0);
                blockEntity.setRecipe(recipe);
                blockEntity.setCanProcess(true);
            }
        });
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<CompactorMenu, CompactorRecipe> {
        public Class<CompactorMenu> getContainerClass() {
            return CompactorMenu.class;
        }

        public Optional<MenuType<CompactorMenu>> getMenuType() {
            return Optional.of((MenuType)MenuRegistry.COMPACTOR_MENU.get());
        }

        public RecipeType<CompactorRecipe> getRecipeType() {
            return RecipeTypes.COMPACTOR;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(CompactorMenu pContainer, CompactorRecipe pRecipe, IRecipeSlotsView pRecipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
            if (pDoTransfer) {
                pContainer.getBlockEntity().setRecipe((AbstractProcessingRecipe)pRecipe);
                Alchemistry.PACKET_HANDLER.sendToServer(new CompactorTransferPacket(pContainer.getBlockEntity().m_58899_(), pRecipe.getOutput(), pMaxTransfer));
            }
            return null;
        }
    }
}

