/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.aecapfix.mixin.powah;

import gripe._90.aecapfix.misc.PowahEnergyStorage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import owmii.powah.Powah;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.forge.ForgeEnvHandler;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;

@Mixin(value={ForgeEnvHandler.class}, remap=false)
public abstract class ForgeEnvHandlerMixin {
    @Inject(method={"lambda$registerTransfer$3"}, at={@At(value="HEAD")}, cancellable=true)
    private void registerCapabilities(AttachCapabilitiesEvent<BlockEntity> event, CallbackInfo ci) {
        Object provider;
        ci.cancel();
        Object object = event.getObject();
        if (object instanceof ReactorPartTile) {
            final ReactorPartTile reactorPart = (ReactorPartTile)object;
            provider = new ICapabilityProvider(){
                private final Set<LazyOptional<Object>> holders = new HashSet<LazyOptional<Object>>();

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (reactorPart.core().isEmpty() || cap == ForgeCapabilities.ENERGY && !reactorPart.isExtractor()) {
                        return LazyOptional.empty();
                    }
                    LazyOptional holder = ((ReactorTile)reactorPart.core().get()).getCapability(cap, side);
                    this.holders.add((LazyOptional<Object>)holder.cast());
                    return holder;
                }

                private void invalidate() {
                    this.holders.forEach(LazyOptional::invalidate);
                    this.holders.clear();
                }
            };
            event.addCapability(Powah.id((String)"reactor_part"), (ICapabilityProvider)provider);
            event.addListener((provider)::invalidate);
        }
        if ((provider = event.getObject()) instanceof AbstractEnergyStorage) {
            final AbstractEnergyStorage energyStorage = (AbstractEnergyStorage)provider;
            provider = new ICapabilityProvider(){
                private final Set<LazyOptional<IEnergyStorage>> holders = new HashSet<LazyOptional<IEnergyStorage>>();

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (cap == ForgeCapabilities.ENERGY && energyStorage.isEnergyPresent(side)) {
                        LazyOptional holder = LazyOptional.of(() -> new PowahEnergyStorage(energyStorage, side));
                        this.holders.add((LazyOptional<IEnergyStorage>)holder.cast());
                        return holder.cast();
                    }
                    return LazyOptional.empty();
                }

                private void invalidate() {
                    this.holders.forEach(LazyOptional::invalidate);
                    this.holders.clear();
                }
            };
            event.addCapability(Powah.id((String)"energy"), (ICapabilityProvider)provider);
            event.addListener((provider)::invalidate);
        }
        if ((provider = event.getObject()) instanceof IInventoryHolder) {
            final IInventoryHolder invHolder = (IInventoryHolder)provider;
            provider = new ICapabilityProvider(){
                private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> invHolder.getInventory().getPlatformWrapper()).cast();

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (cap == ForgeCapabilities.ITEM_HANDLER && !invHolder.getInventory().isBlank()) {
                        return this.holder.cast();
                    }
                    return LazyOptional.empty();
                }

                private void invalidate() {
                    this.holder.invalidate();
                }
            };
            event.addCapability(Powah.id((String)"inv"), (ICapabilityProvider)provider);
            event.addListener((provider)::invalidate);
        }
        if ((provider = event.getObject()) instanceof ITankHolder) {
            final ITankHolder tankHolder = (ITankHolder)provider;
            provider = new ICapabilityProvider(){
                private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> tankHolder.getTank().getPlatformWrapper()).cast();

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder.cast());
                }

                private void invalidate() {
                    this.holder.invalidate();
                }
            };
            event.addCapability(Powah.id((String)"tank"), (ICapabilityProvider)provider);
            event.addListener((provider)::invalidate);
        }
    }
}

