/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.aecapfix.mixin.ae2;

import appeng.capabilities.Capabilities;
import appeng.core.AppEng;
import appeng.helpers.externalstorage.GenericStackFluidStorage;
import appeng.helpers.externalstorage.GenericStackItemStorage;
import appeng.init.InitCapabilities;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InitCapabilities.class}, remap=false)
public abstract class InitCapabilitiesMixin {
    @Inject(method={"registerGenericInvWrapper"}, at={@At(value="HEAD")}, cancellable=true)
    private static void registerCapabilities(final AttachCapabilitiesEvent<BlockEntity> event, CallbackInfo ci) {
        ci.cancel();
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final BlockEntity be;
            private final Set<LazyOptional<GenericStackItemStorage>> itemHandlers;
            private final Set<LazyOptional<GenericStackFluidStorage>> fluidHandlers;
            {
                this.be = (BlockEntity)event.getObject();
                this.itemHandlers = new HashSet<LazyOptional<GenericStackItemStorage>>();
                this.fluidHandlers = new HashSet<LazyOptional<GenericStackFluidStorage>>();
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    LazyOptional handler = this.be.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackItemStorage::new);
                    this.itemHandlers.add((LazyOptional<GenericStackItemStorage>)handler);
                    return handler.cast();
                }
                if (cap == ForgeCapabilities.FLUID_HANDLER) {
                    LazyOptional handler = this.be.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackFluidStorage::new);
                    this.fluidHandlers.add((LazyOptional<GenericStackFluidStorage>)handler);
                    return handler.cast();
                }
                return LazyOptional.empty();
            }

            private void invalidate() {
                this.itemHandlers.forEach(LazyOptional::invalidate);
                this.fluidHandlers.forEach(LazyOptional::invalidate);
                this.itemHandlers.clear();
                this.fluidHandlers.clear();
            }
        };
        event.addCapability(AppEng.makeId((String)"generic_inv_wrapper"), provider);
        event.addListener((provider)::invalidate);
    }
}

