/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.system;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModDamageSource;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityOxygenSystem {
    public static void oxygenTick(LivingEntity entity, ServerLevel level) {
        boolean hasOxygenatedSpaceSuit;
        if (!AdAstraConfig.doOxygen) {
            return;
        }
        if (entity.m_21222_()) {
            return;
        }
        if (ModUtils.checkTag((Entity)entity, ModTags.LIVES_WITHOUT_OXYGEN)) {
            return;
        }
        if (OxygenUtils.levelHasOxygen((Level)level) && !entity.m_5842_()) {
            return;
        }
        boolean entityHasOxygen = OxygenUtils.entityHasOxygen((Level)level, entity);
        boolean bl = hasOxygenatedSpaceSuit = SpaceSuit.hasOxygenatedSpaceSuit(entity) && SpaceSuit.hasFullSet(entity);
        if (entityHasOxygen && hasOxygenatedSpaceSuit && entity.m_5842_() && !entity.m_6040_() && !entity.m_21023_(MobEffects.f_19608_)) {
            EntityOxygenSystem.consumeOxygen(entity);
            return;
        }
        if (!entityHasOxygen) {
            if (hasOxygenatedSpaceSuit) {
                EntityOxygenSystem.consumeOxygen(entity);
            } else if (!ModUtils.armourIsOxygenated(entity)) {
                entity.m_6469_(ModDamageSource.OXYGEN, (float)AdAstraConfig.oxygenDamage);
                entity.m_20301_(-40);
            }
        }
    }

    private static void consumeOxygen(LivingEntity entity) {
        if (entity.m_9236_().m_46467_() % 3L == 0L) {
            entity.m_20301_(Math.min(entity.m_6062_(), entity.m_20146_() + 40));
            SpaceSuit.consumeSpaceSuitOxygen(entity, FluidHooks.buckets((int)1) / 1000L);
        }
    }
}

