/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import earth.terrarium.ad_astra.common.screen.PlanetSelectionMenuProvider;
import earth.terrarium.botarium.api.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.api.menu.MenuHooks;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PlanetGuiCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"planetgui").requires(source -> source.m_6761_(2))).executes(PlanetGuiCommand::executeSimple)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(PlanetGuiCommand::executePartial)).then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(PlanetGuiCommand::executeFull))));
    }

    private static int executeSimple(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return PlanetGuiCommand.execute(List.of(((CommandSourceStack)context.getSource()).m_81375_()), 4);
    }

    private static int executePartial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return PlanetGuiCommand.execute(EntityArgument.m_91461_(context, (String)"target"), 4);
    }

    private static int executeFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection entities = EntityArgument.m_91461_(context, (String)"target");
        int tier = IntegerArgumentType.getInteger(context, (String)"tier");
        return PlanetGuiCommand.execute(entities, tier);
    }

    private static int execute(Collection<? extends Entity> entities, int tier) {
        entities.forEach(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.f_36095_.m_6877_(player);
                MenuHooks.openMenu((ServerPlayer)((ServerPlayer)player), (ExtraDataMenuProvider)new PlanetSelectionMenuProvider(tier));
            }
        });
        return 1;
    }
}

