/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.ProcessingMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.CompressorConfig;
import earth.terrarium.ad_astra.common.recipe.CompressingRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.CompressorMenu;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressorBlockEntity
extends ProcessingMachineBlockEntity
implements EnergyBlock {
    private InsertOnlyEnergyContainer energyContainer;

    public CompressorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.COMPRESSOR.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new CompressorMenu(syncId, inv, this);
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 1;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.m_5776_() && this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
            ItemStack input = this.m_8020_(0);
            if (!input.m_41619_() && (input.m_150930_(this.inputStack.m_41720_()) || this.inputStack.m_41619_())) {
                this.setActive(true);
                if (this.cookTime < this.cookTimeTotal) {
                    ++this.cookTime;
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                } else if (!this.outputStack.m_41619_()) {
                    input.m_41774_(1);
                    this.finishCooking();
                } else {
                    CompressingRecipe recipe = this.createRecipe(input, true);
                    if (recipe != null) {
                        this.cookTimeTotal = recipe.getCookTime();
                        this.cookTime = 0;
                    }
                }
            } else if (!this.outputStack.m_41619_()) {
                this.stopCooking();
            } else {
                this.setActive(false);
            }
        }
    }

    public CompressingRecipe createRecipe(ItemStack testStack, boolean checkOutput) {
        this.stopCooking();
        CompressingRecipe recipe = CompressingRecipe.findFirst(this.f_58857_, f -> f.test(testStack));
        if (recipe != null) {
            if (checkOutput) {
                ItemStack outputSlot = this.m_8020_(1);
                ItemStack output = recipe.m_8043_();
                if (!outputSlot.m_41619_() && !outputSlot.m_41720_().equals(recipe.m_8043_().m_41720_()) || outputSlot.m_41613_() + output.m_41613_() > outputSlot.m_41741_()) {
                    return null;
                }
            }
            this.outputStack = recipe.m_8043_();
            this.inputStack = testStack;
        }
        return recipe;
    }

    public long getEnergyPerTick() {
        return CompressorConfig.energyPerTick;
    }

    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, CompressorConfig.maxEnergy)) : this.energyContainer;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

