/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.data.BlockStateDataGen;
import tv.soaryn.xycraft.core.data.ConnectedModelProvider;
import tv.soaryn.xycraft.core.data.CoreResources;
import tv.soaryn.xycraft.world.content.WorldContent;

public class WorldBlockStateDataGen
extends BlockStateDataGen {
    public WorldBlockStateDataGen(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, WorldContent.Map, "xycraft_world", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        super.registerStatesAndModels();
        this.buildConnectedBlock(WorldContent.GlassViewerDark, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.GlassViewerPhantom, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.GlassViewerPhantomGlowing, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        this.buildConnectedBlock(WorldContent.GlassViewerPhantomDark, x$0 -> this.translucent((ConnectedModelProvider)x$0));
        WorldContent.AureyBlockMatte.values().forEach(blockContent -> {
            blockContent.withModelPath("aluminum_storage");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setTintIndex(0).end().renderType("cutout").texture("particle", "xycraft_world:block/connected/aluminum_storage_single"));
        });
        WorldContent.AureyBlockMatteGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath("aluminum_storage");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setTintIndex(0).end().renderType("cutout").texture("particle", "xycraft_world:block/connected/aluminum_storage_single"));
        });
        WorldContent.AureyBlockFx.values().forEach(blockContent -> {
            blockContent.withModelPath("aurey_cloud");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("particle", CoreResources.CloudFX).texture("base", CoreResources.CloudFX));
        });
        WorldContent.AureyBlockFxGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath("aurey_cloud");
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("particle", CoreResources.CloudFX).texture("base", CoreResources.CloudFX));
        });
        WorldContent.GlassViewerRgb.values().forEach(blockContent -> this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("translucent").texture("particle", "xycraft_world:block/connected/glass_viewer_rgb_base").texture("base", "xycraft_world:block/connected/glass_viewer_rgb_base")));
        WorldContent.GlassViewerRgbGlowing.values().forEach(blockContent -> {
            blockContent.withModelPath(WorldContent.GlassViewerRgb.get(DyeColor.WHITE).modelPath());
            this.buildConnectedBlock((BlockContent)blockContent, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("translucent").texture("particle", "xycraft_world:block/connected/glass_viewer_rgb_base").texture("base", "xycraft_world:block/connected/glass_viewer_rgb_base"));
        });
        WorldContent.ImmortalStone.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        WorldContent.XychoriumStorage.values().forEach(wrapper -> this.buildConnectedBlock((BlockContent)wrapper, builder -> builder.setBaseEmissivity(15).setBaseTintIndex(0).setTintIndex(0).end().renderType("cutout").texture("base", CoreResources.CloudFX).texture("particle", CoreResources.CloudFX)));
        String invertedBrickModelPath = WorldContent.InvertedBricksCloud.get(CustomColors.Blue).modelPath();
        BlockModelBuilder brickModel = (BlockModelBuilder)this.cloudModelTintable(invertedBrickModelPath).texture("tex", "xycraft_world:block/" + invertedBrickModelPath);
        WorldContent.InvertedBricksCloud.forEach((customColors, blockContent) -> this.simpleBlock(blockContent.block(), (ModelFile)brickModel));
        String invertedTileModelPath = WorldContent.InvertedTilesCloud.get(CustomColors.Blue).modelPath();
        BlockModelBuilder tileModel = (BlockModelBuilder)this.cloudModelTintable(invertedTileModelPath).texture("tex", "xycraft_world:block/" + invertedTileModelPath);
        WorldContent.InvertedTilesCloud.forEach((customColors, blockContent) -> this.simpleBlock(blockContent.block(), (ModelFile)tileModel));
        String lampModelPath = WorldContent.LampRgbGlowing.get(DyeColor.WHITE).modelPath();
        BlockModelBuilder lampModel = (BlockModelBuilder)((ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(lampModelPath, "block/block")).texture("texture_single", "xycraft_world:block/connected/" + lampModelPath + "_single")).texture("texture_connected", "xycraft_world:block/connected/" + lampModelPath)).texture("base", CoreResources.CloudFX)).texture("particle", CoreResources.CloudFX)).renderType("cutout")).customLoader(ConnectedModelProvider::new)).setBaseEmissivity(15).setBaseTintIndex(0).end();
        WorldContent.LampRgbGlowing.values().forEach(content -> this.simpleBlock(content.block(), (ModelFile)lampModel));
        WorldContent.LampRgbGlowingInverted.values().forEach(content -> this.simpleBlock(content.block(), (ModelFile)lampModel));
    }
}

