/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override.data;

import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XycraftCore;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.override.content.OverrideContent;

public class OverrideBlockTagProvider
extends BlockTagsProvider {
    public OverrideBlockTagProvider(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
        super(generator, "xycraft_override", existingFileHelper);
    }

    protected void m_6577_() {
        this.appendTagToBlock((TagKey<Block>)BlockTags.f_144282_, OverrideContent.Map.ListOfBlocks);
        this.copyTagsFromTo(Blocks.f_50222_, OverrideContent.StoneBricks);
        this.copyTagsFromTo(Blocks.f_50225_, OverrideContent.ChiseledStoneBricks);
        this.copyTagsFromTo(Blocks.f_50223_, OverrideContent.MossyStoneBricks);
        this.copyTagsFromTo(Blocks.f_50063_, OverrideContent.ChiseledSandstone);
        this.copyTagsFromTo(Blocks.f_50395_, OverrideContent.ChiseledRedSandstone);
        this.copyTagsFromTo(Blocks.f_50378_, OverrideContent.PrismarineBricks);
        this.copyTagsFromTo(Blocks.f_220844_, OverrideContent.MudBricks);
        this.copyTagsFromTo(Blocks.f_50076_, OverrideContent.Bricks);
        this.copyTagsFromTo(Blocks.f_152550_, OverrideContent.DeepslateBricks);
        this.copyTagsFromTo(Blocks.f_152559_, OverrideContent.DeepslateTiles);
        this.copyTagsFromTo(Blocks.f_152593_, OverrideContent.ChiseledDeepslate);
        this.copyTagsFromTo(Blocks.f_50712_, OverrideContent.ChiseledNetherBricks);
        this.copyTagsFromTo(Blocks.f_50737_, OverrideContent.ChiseledPolishedBlackstone);
        this.copyTagsFromTo(Blocks.f_50706_, OverrideContent.GildedBlackstone);
        this.copyTagsFromTo(Blocks.f_50443_, OverrideContent.EndStoneBricks);
        this.copyTagsFromTo(Blocks.f_50441_, OverrideContent.PurpurPillar);
        this.copyTagsFromTo(Blocks.f_50492_, OverrideContent.PurpurBlock);
        this.copyTagsFromTo(Blocks.f_50714_, OverrideContent.QuartzBricks);
        this.copyTagsFromTo(Blocks.f_50197_, OverrideContent.NetherBricks);
        this.copyTagsFromTo(Blocks.f_50450_, OverrideContent.Magma);
    }

    private void copyTagsFromTo(Block block, EnumMap<CustomColors, BlockContent> contentMap) {
        contentMap.forEach((customColors, blockContent) -> this.copyTagsFromTo(block, (BlockContent)blockContent));
    }

    private void copyTagsFromTo(Block block, BlockContent content) {
        Optional rTag = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getReverseTag((Object)block);
        rTag.ifPresent(blockIReverseTag -> blockIReverseTag.getTagKeys().forEach(blockTagKey -> {
            XycraftCore.LOGGER.debug(block.m_49954_().getString() + " : " + blockTagKey.f_203868_().m_135815_());
            this.m_206424_((TagKey)blockTagKey).m_126582_((Object)content.block());
        }));
    }

    private void appendTagToBlock(TagKey<Block> tag, Iterable<BlockContent> blocks) {
        TagsProvider.TagAppender t = this.m_206424_(tag);
        for (BlockContent block : blocks) {
            t.m_126582_((Object)block.block());
        }
    }

    private void appendTagToBlock(TagKey<Block> tag, BlockContent block) {
        TagsProvider.TagAppender t = this.m_206424_(tag);
        t.m_126582_((Object)block.block());
    }
}

