/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import de.castcrafter.travelanchors.ModBlocks;
import de.castcrafter.travelanchors.TeleportHandler;
import de.castcrafter.travelanchors.TravelAnchorList;
import de.castcrafter.travelanchors.TravelAnchors;
import de.castcrafter.travelanchors.render.OutlineBuffer;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.render.RenderHelperLevel;

public class TravelAnchorRenderer {
    public static final RenderType BOLD_LINES = TravelAnchorRenderer.createLines("bold_lines", 3);
    public static final RenderType VERLY_BOLD_LINES = TravelAnchorRenderer.createLines("very_bold_lines", 5);
    public static BakedModel MODEL = null;

    private static RenderType createLines(String name, int strength) {
        return RenderType.m_173215_((String)(TravelAnchors.getInstance().modid + "_" + name), (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(strength))).m_110669_(RenderStateShard.f_110119_).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110129_).m_110687_(RenderStateShard.f_110114_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    public static void renderAnchors(RenderLevelStageEvent event) {
        PoseStack poseStack = event.getPoseStack();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level != null && player != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS && (TeleportHandler.canBlockTeleport((Player)player) || TeleportHandler.canItemTeleport((Player)player, InteractionHand.MAIN_HAND) || TeleportHandler.canItemTeleport((Player)player, InteractionHand.OFF_HAND))) {
            double maxDistanceSq = TeleportHandler.getMaxDistance((Player)player);
            maxDistanceSq *= maxDistanceSq;
            TravelAnchorList list = TravelAnchorList.get((Level)Minecraft.m_91087_().f_91073_);
            double posX = Mth.m_14139_((double)event.getPartialTick(), (double)player.f_19854_, (double)player.m_20185_());
            double posY = Mth.m_14139_((double)event.getPartialTick(), (double)player.f_19855_, (double)player.m_20186_());
            double posZ = Mth.m_14139_((double)event.getPartialTick(), (double)player.f_19856_, (double)player.m_20189_());
            Vec3 projection = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            double projPosX = projection.f_82479_;
            double projPosY = projection.f_82480_;
            double projPosZ = projection.f_82481_;
            Pair<BlockPos, String> pair = TeleportHandler.getAnchorToTeleport((Level)level, (Player)player, player.m_20183_().m_7495_());
            for (BlockPos pos : list.anchors.keySet()) {
                TravelAnchorList.Entry entry;
                double distanceSq = pos.m_203198_(posX, posY, posZ);
                if (!(distanceSq <= maxDistanceSq) || (entry = list.getEntry(pos)) == null) continue;
                int light = level.m_46805_(pos) ? LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, pos), (int)level.m_45517_(LightLayer.SKY, pos)) : LightTexture.m_109885_((int)15, (int)15);
                boolean active = pair != null && pos.equals(pair.getLeft());
                boolean directText = distanceSq <= 225.0;
                poseStack.m_85836_();
                RenderHelperLevel.loadCameraPosition((Camera)event.getCamera(), (PoseStack)poseStack, (BlockPos)pos);
                if (distanceSq > 100.0) {
                    double distance = Math.sqrt(distanceSq);
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    double log = Math.log(distance) / 2.3;
                    float scale = (float)(log * log * log);
                    poseStack.m_85841_(scale, scale, scale);
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                }
                TravelAnchorRenderer.renderAnchor(poseStack, OutlineBuffer.INSTANCE, directText ? entry.name : null, entry.state, light, true, active, distanceSq, null);
                poseStack.m_85849_();
                if (directText || entry.name.trim().isEmpty()) continue;
                poseStack.m_85836_();
                double blockScale = Math.sqrt(0.0035 * Math.sqrt(distanceSq));
                if (blockScale < (double)0.1f) {
                    blockScale = 0.1f;
                }
                blockScale *= Math.sin(Math.toRadians((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() / 4.0));
                if (active) {
                    blockScale *= 1.3;
                }
                RenderHelperLevel.loadCameraPosition((Camera)event.getCamera(), (PoseStack)poseStack, (double)projPosX, (double)projPosY, (double)projPosZ);
                CircleRotation rot = TravelAnchorRenderer.rotateCircle(projPosX - ((double)pos.m_123341_() + 0.5), projPosY - ((double)pos.m_123342_() + 0.5 + 0.5 * blockScale), projPosZ - ((double)pos.m_123343_() + 0.5));
                rot.apply(poseStack);
                poseStack.m_85837_(0.0, 5.0, 0.0);
                double doubleScale = 0.1;
                doubleScale *= Math.sin(Math.toRadians((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() / 4.0));
                if (active) {
                    doubleScale *= 1.3;
                }
                float scale = (float)doubleScale;
                rot.reverse(poseStack);
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                poseStack.m_85837_(0.0, 0.05 + doubleScale * 9.0, 0.0);
                poseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
                poseStack.m_85841_(-scale, -scale, scale);
                int color = 0xFFFFFF;
                if (active) {
                    color = ChatFormatting.GOLD.m_126665_() == null ? 0xFFFFFF : ChatFormatting.GOLD.m_126665_();
                }
                Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
                MutableComponent tc = Component.m_237113_((String)entry.name.trim());
                float textOpacitySetting = Minecraft.m_91087_().f_91066_.m_92141_(0.5f);
                int alpha = (int)(textOpacitySetting * 255.0f) << 24;
                float halfWidth = -Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tc) / 2;
                Minecraft.m_91087_().f_91062_.m_92841_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, (MultiBufferSource)OutlineBuffer.INSTANCE, true, alpha, LightTexture.m_109885_((int)15, (int)15));
                Minecraft.m_91087_().f_91062_.m_92841_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, (MultiBufferSource)OutlineBuffer.INSTANCE, false, 0, LightTexture.m_109885_((int)15, (int)15));
                poseStack.m_85849_();
            }
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        }
    }

    public static void renderAnchor(PoseStack poseStack, MultiBufferSource buffer, @Nullable String name, BlockState state, int light, boolean glow, boolean active, double distanceSq, @Nullable ModelData modelData) {
        if (state == null || state.m_60734_() == ModBlocks.travelAnchor) {
            VertexConsumer vertex = buffer.m_6299_(RenderType.m_110451_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), vertex, state, MODEL, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        } else {
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, poseStack, buffer, light, OverlayTexture.f_118083_, modelData == null ? ModelData.EMPTY : modelData, null);
        }
        if (glow) {
            RenderType type = distanceSq > 7225.0 ? RenderType.m_110504_() : (distanceSq > 1444.0 ? BOLD_LINES : VERLY_BOLD_LINES);
            VertexConsumer vertex = buffer.m_6299_(type);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertex, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (name != null && !name.trim().isEmpty()) {
            double doubleScale = Math.sqrt(0.0035 * Math.sqrt(distanceSq));
            if (doubleScale < (double)0.1f) {
                doubleScale = 0.1f;
            }
            doubleScale *= Math.sin(Math.toRadians((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() / 4.0));
            if (active) {
                doubleScale *= 1.3;
            }
            float scale = (float)doubleScale;
            poseStack.m_85836_();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            poseStack.m_85837_(0.5, 1.05 + doubleScale * 9.0, 0.5);
            poseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
            poseStack.m_85841_(-scale, -scale, scale);
            int color = 0xFFFFFF;
            if (active) {
                color = ChatFormatting.GOLD.m_126665_() == null ? 0xFFFFFF : ChatFormatting.GOLD.m_126665_();
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            MutableComponent tc = Component.m_237113_((String)name.trim());
            float textOpacitySetting = Minecraft.m_91087_().f_91066_.m_92141_(0.5f);
            int alpha = (int)(textOpacitySetting * 255.0f) << 24;
            float halfWidth = -Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tc) / 2;
            Minecraft.m_91087_().f_91062_.m_92841_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, true, alpha, LightTexture.m_109885_((int)15, (int)15));
            Minecraft.m_91087_().f_91062_.m_92841_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, buffer, false, 0, LightTexture.m_109885_((int)15, (int)15));
            poseStack.m_85849_();
        }
    }

    private static CircleRotation rotateCircle(double x, double y, double z) {
        float yr = Float.NaN;
        if (z != 0.0) {
            yr = (float)(Math.atan2(x, z) + 1.5707963267948966);
        }
        double hor = Math.sqrt(x * x + z * z);
        float zr = (float)(Math.atan2(hor, y) + Math.PI);
        return new CircleRotation(yr, zr);
    }

    private record CircleRotation(float y, float z) {
        public void apply(PoseStack poseStack) {
            if (!Float.isNaN(this.y)) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.y));
            }
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.z));
        }

        public void reverse(PoseStack poseStack) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(-this.z));
            if (!Float.isNaN(this.y)) {
                poseStack.m_85845_(Vector3f.f_122225_.m_122270_(-this.y));
            }
        }
    }
}

