/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors.network;

import de.castcrafter.travelanchors.TeleportHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ClientEventMessage(Type type) {

    public static enum Type {
        JUMP,
        EMPTY_HAND_INTERACT,
        SNEAK,
        JUMP_TP;

    }

    public static class Serializer
    implements PacketSerializer<ClientEventMessage> {
        public Class<ClientEventMessage> messageClass() {
            return ClientEventMessage.class;
        }

        public void encode(ClientEventMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)msg.type);
        }

        public ClientEventMessage decode(FriendlyByteBuf buffer) {
            return new ClientEventMessage((Type)buffer.m_130066_(Type.class));
        }
    }

    public static class Handler
    implements PacketHandler<ClientEventMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ClientEventMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player != null) {
                switch (msg.type) {
                    case JUMP: {
                        if (!TeleportHandler.canElevate((Player)player) || !TeleportHandler.elevateUp((Player)player)) break;
                        player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0));
                        break;
                    }
                    case EMPTY_HAND_INTERACT: {
                        if (!TeleportHandler.canBlockTeleport((Player)player) || player.m_6144_()) break;
                        TeleportHandler.anchorTeleport(player.m_20193_(), (Player)player, player.m_20183_().m_7949_().m_7495_(), InteractionHand.MAIN_HAND);
                        break;
                    }
                    case SNEAK: {
                        if (!TeleportHandler.canElevate((Player)player) || !TeleportHandler.elevateDown((Player)player)) break;
                        player.m_20256_(player.m_20184_().m_82542_(1.0, 0.0, 1.0));
                        break;
                    }
                    case JUMP_TP: {
                        if (!TeleportHandler.canBlockTeleport((Player)player) || player.m_6144_()) break;
                        TeleportHandler.anchorTeleport(player.m_20193_(), (Player)player, player.m_20183_().m_7949_().m_7495_(), null);
                    }
                }
            }
            return true;
        }
    }
}

