/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import quek.undergarden.registry.UGItems;

public class SlingshotFireTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation("undergarden", "slingshot_fire");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext context) {
        ItemPredicate slingshotPredicate = ItemPredicate.m_45051_((JsonElement)json.get("slingshot"));
        ItemPredicate ammoPredicate = ItemPredicate.m_45051_((JsonElement)json.get("ammo"));
        return new TriggerInstance(entityPredicate, slingshotPredicate, ammoPredicate);
    }

    public void trigger(ServerPlayer shooter, ItemStack slingshot, ItemStack ammo) {
        this.m_66234_(shooter, triggerInstance -> triggerInstance.matches(slingshot, ammo));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate slingshot;
        private final ItemPredicate ammo;

        public TriggerInstance(EntityPredicate.Composite player, ItemPredicate slingshot, ItemPredicate ammo) {
            super(ID, player);
            this.slingshot = slingshot;
            this.ammo = ammo;
        }

        public static TriggerInstance shotItem(ItemLike slingshot, ItemLike ammo) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{slingshot}).m_45077_(), ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{ammo}).m_45077_());
        }

        public static TriggerInstance shotItem(ItemLike ammo) {
            return TriggerInstance.shotItem((ItemLike)UGItems.SLINGSHOT.get(), ammo);
        }

        public boolean matches(ItemStack slingshot, ItemStack ammo) {
            return this.slingshot.m_45049_(slingshot) && this.ammo.m_45049_(ammo);
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject object = super.m_7683_(conditions);
            object.add("slingshot", this.slingshot.m_45048_());
            object.add("ammo", this.ammo.m_45048_());
            return object;
        }
    }
}

