/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.rotspawn.Rotbeast;

public class RotbeastModel<T extends Rotbeast>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart torso;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public RotbeastModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.torso = root.m_171324_("torso");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightArm = root.m_171324_("rightArm");
        this.leftArm = root.m_171324_("leftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)15.0f, (float)24.0f, (float)0.0f));
        PartDefinition lowerTorso = torso.m_171599_("lowerTorso", CubeListBuilder.m_171558_().m_171514_(50, 46).m_171488_(-13.0f, -14.25f, -6.0f, 26.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-15.0f, (float)-16.75f, (float)5.5f));
        PartDefinition upperTorso = lowerTorso.m_171599_("upperTorso", CubeListBuilder.m_171558_().m_171514_(32, 91).m_171488_(-15.0f, -19.0f, -8.5f, 30.0f, 19.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.75f, (float)-0.5f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(56, 10).m_171480_().m_171488_(-3.5f, 0.0f, -4.0f, 9.0f, 19.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-7.5f, (float)5.0f, (float)5.5f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(56, 10).m_171488_(-5.5f, 0.0f, -4.0f, 9.0f, 19.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.5f, (float)5.0f, (float)5.5f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(80, 26).m_171488_(-6.0f, -6.5f, -13.0f, 12.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-14.5f, (float)-7.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-6.0f, -0.5f, -12.0f, 12.0f, 5.0f, 12.0f, new CubeDeformation(0.25f)).m_171514_(0, 1).m_171488_(-6.0f, -3.0f, -12.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-1.0f));
        PartDefinition rightArm = partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(2, 86).m_171488_(-7.0f, -1.0f, -4.0f, 7.0f, 34.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-15.0f, (float)-17.0f, (float)2.0f));
        PartDefinition leftArm = partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(2, 86).m_171480_().m_171488_(0.0f, -1.0f, -4.0f, 7.0f, 34.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)15.0f, (float)-17.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        AnimationUtils.m_102082_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.jaw.f_104203_ = entity.m_5912_() ? 0.3491f : 0.0f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int attackTimer = ((Rotbeast)((Object)entityIn)).getAttackTimer();
        if (attackTimer > 0) {
            this.rightArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attackTimer - partialTick), (float)10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attackTimer - partialTick), (float)10.0f);
        } else {
            this.rightArm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableSet.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.leftArm, (Object[])new ModelPart[0]);
    }
}

