/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import net.minecraft.Util;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.data.UGAdvancements;
import quek.undergarden.data.UGBiomeTags;
import quek.undergarden.data.UGBlockStates;
import quek.undergarden.data.UGBlockTags;
import quek.undergarden.data.UGEntityTags;
import quek.undergarden.data.UGFluidTags;
import quek.undergarden.data.UGItemModels;
import quek.undergarden.data.UGItemTags;
import quek.undergarden.data.UGLang;
import quek.undergarden.data.UGLootTables;
import quek.undergarden.data.UGRecipes;
import quek.undergarden.data.UGSoundDefinitions;
import quek.undergarden.entity.projectile.Blisterbomb;
import quek.undergarden.entity.projectile.slingshot.DepthrockPebble;
import quek.undergarden.entity.projectile.slingshot.GooBall;
import quek.undergarden.entity.projectile.slingshot.Gronglet;
import quek.undergarden.entity.projectile.slingshot.RottenBlisterberry;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.item.tool.slingshot.SlingshotItem;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGCauldronInteractions;
import quek.undergarden.registry.UGConfiguredCarvers;
import quek.undergarden.registry.UGConfiguredFeatures;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGFoliagePlacers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPlacedFeatures;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGTreeDecoratorTypes;
import quek.undergarden.registry.UGTrunkPlacerTypes;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";
    public static final Logger LOGGER = LogManager.getLogger();

    public Undergarden() {
        DeferredRegister[] registers;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGBiomes.BIOMES, UGBlockEntities.BLOCK_ENTITIES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGConfiguredCarvers.CONFIGURED_CARVERS, UGConfiguredFeatures.CONFIGURED_FEATURES, UGEffects.EFFECTS, UGEnchantments.ENCHANTMENTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGFluids.TYPES, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPlacedFeatures.PLACED_FEATURES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructures.STRUCTURES, UGTreeDecoratorTypes.TREE_DECORATORS, UGTrunkPlacerTypes.TRUNK_PLACERS, UGFoliagePlacers.FOLIAGE_PLACERS}) {
            register.register(bus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UndergardenConfig.COMMON_SPEC);
    }

    public void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)UGBlocks.DEPTHROCK.get()).m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : ((Block)UGBlocks.SHIVERSTONE.get()).m_49966_()));
        event.enqueueWork(() -> {
            UGCriteria.register();
            UGCauldronInteractions.register();
            DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

                public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    BucketItem bucketitem = (BucketItem)stack.m_41720_();
                    BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    ServerLevel world = source.m_7727_();
                    if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                        bucketitem.m_142131_(null, (Level)world, stack, blockpos);
                        return new ItemStack((ItemLike)Items.f_42446_);
                    }
                    return this.defaultBehavior.m_6115_(source, stack);
                }
            };
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.VIRULENT_MIX_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GWIBLING_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new DepthrockPebble(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GOO_BALL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new GooBall(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new RottenBlisterberry(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.BLISTERBOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new Blisterbomb(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGBlocks.GRONGLET.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new Gronglet(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)UGItems.BLOOD_GLOBULE.get()), (Potion)((Potion)UGPotions.BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Block)UGBlocks.VEIL_MUSHROOM.get()).m_5456_(), (Potion)((Potion)UGPotions.FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((StemGrownBlock)UGBlocks.GLOOMGOURD.get()).m_5456_(), (Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)UGItems.DROOPFRUIT.get()), (Potion)((Potion)UGPotions.GLOWING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.GLOWING.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_GLOWING.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.DROOPFRUIT.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.UNDERBEANS.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.BLOOD_GLOBULE.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLOOMGOURD_SEEDS.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLITTERKELP.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGItems.DITCHBULB.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_STEM.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_STEM.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_STEM.get()));
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(UGBlocks.SMOGSTEM_SAPLING.getId(), UGBlocks.POTTED_SMOGSTEM_SAPLING);
            pot.addPlant(UGBlocks.WIGGLEWOOD_SAPLING.getId(), UGBlocks.POTTED_WIGGLEWOOD_SAPLING);
            pot.addPlant(UGBlocks.SHIMMERWEED.getId(), UGBlocks.POTTED_SHIMMERWEED);
            pot.addPlant(UGBlocks.INDIGO_MUSHROOM.getId(), UGBlocks.POTTED_INDIGO_MUSHROOM);
            pot.addPlant(UGBlocks.VEIL_MUSHROOM.getId(), UGBlocks.POTTED_VEIL_MUSHROOM);
            pot.addPlant(UGBlocks.INK_MUSHROOM.getId(), UGBlocks.POTTED_INK_MUSHROOM);
            pot.addPlant(UGBlocks.BLOOD_MUSHROOM.getId(), UGBlocks.POTTED_BLOOD_MUSHROOM);
            pot.addPlant(UGBlocks.GRONGLE_SAPLING.getId(), UGBlocks.POTTED_GRONGLE_SAPLING);
            pot.addPlant(UGBlocks.AMOROUS_BRISTLE.getId(), UGBlocks.POTTED_AMOROUS_BRISTLE);
            pot.addPlant(UGBlocks.MISERABELL.getId(), UGBlocks.POTTED_MISERABELL);
            pot.addPlant(UGBlocks.BUTTERBUNCH.getId(), UGBlocks.POTTED_BUTTERBUNCH);
            WoodType.m_61844_((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            WoodType.m_61844_((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            WoodType.m_61844_((WoodType)UGBlocks.GRONGLE_WOODTYPE);
            SlingshotItem.registerAmmo((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new DepthrockPebble(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new RottenBlisterberry(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.GOO_BALL.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new GooBall(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGBlocks.GRONGLET.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new Gronglet((LivingEntity)shooter, level);
                }

                @Override
                public SoundEvent getFiringSound() {
                    return (SoundEvent)UGSoundEvents.GRONGLET_SHOOT.get();
                }
            });
            FireBlock fire = (FireBlock)Blocks.f_50083_;
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.GRONGLE_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_SMOGSTEM_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_GRONGLE_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.GRONGLE_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_SMOGSTEM_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_GRONGLE_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.GRONGLE_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.FROZEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.SHIMMERWEED.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.TALL_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.TALL_SHIMMERWEED.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.UNDERBEAN_BUSH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.BLISTERBERRY_BUSH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.DITCHBULB_PLANT.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.DROOPVINE.get(), 15, 60);
            fire.m_53444_((Block)UGBlocks.DROOPVINE_PLANT.get(), 15, 60);
            fire.m_53444_((Block)UGBlocks.AMOROUS_BRISTLE.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.MISERABELL.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.BUTTERBUNCH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.MOGMOSS_RUG.get(), 60, 20);
            fire.m_53444_((Block)UGBlocks.BOOMGOURD.get(), 15, 100);
            fire.m_53444_((Block)UGBlocks.GRONGLET.get(), 100, 100);
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            Sheets.addWoodType((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            Sheets.addWoodType((WoodType)UGBlocks.GRONGLE_WOODTYPE);
        });
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("rotten_blisterberry"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_((Item)UGItems.ROTTEN_BLISTERBERRY.get()) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("goo_ball"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_((Item)UGItems.GOO_BALL.get()) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("gronglet"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_(((Block)UGBlocks.GRONGLET.get()).m_5456_()) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("self_sling"), (stack, level, entity, seed) -> entity != null && stack.getEnchantmentLevel((Enchantment)UGEnchantments.SELF_SLING.get()) > 0 ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.CLOGGRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new UGBlockStates(generator, helper));
            generator.m_236039_(true, (DataProvider)new UGItemModels(generator, helper));
            generator.m_236039_(true, (DataProvider)new UGLang(generator));
            generator.m_236039_(true, (DataProvider)new UGSoundDefinitions(generator, helper));
        }
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new UGRecipes(generator));
            generator.m_236039_(true, (DataProvider)new UGLootTables(generator));
            UGBlockTags blockTags = new UGBlockTags(generator, helper);
            generator.m_236039_(true, (DataProvider)blockTags);
            generator.m_236039_(true, (DataProvider)new UGItemTags(generator, blockTags, helper));
            generator.m_236039_(true, (DataProvider)new UGEntityTags(generator, helper));
            generator.m_236039_(true, (DataProvider)new UGAdvancements(generator, helper));
            generator.m_236039_(true, (DataProvider)new UGFluidTags(generator, helper));
            generator.m_236039_(true, (DataProvider)new UGBiomeTags(generator, helper));
        }
    }
}

