/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.biome.Biome;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaTransformer0;

public class InitialLayer
implements AreaTransformer0 {
    private final RegionType regionType;
    private final WeightedRandomList<WeightedEntry.Wrapper<Region>> weightedEntries;

    public InitialLayer(RegistryAccess registryAccess, RegionType type) {
        Registry biomeRegistry = registryAccess.m_175515_(Registry.f_122885_);
        this.regionType = type;
        this.weightedEntries = WeightedRandomList.create((List)Regions.get(this.regionType).stream().filter(region -> {
            AtomicBoolean biomesAdded = new AtomicBoolean(false);
            region.addBiomes((Registry<Biome>)biomeRegistry, pair -> biomesAdded.set(true));
            return region.getType() == type && biomesAdded.get();
        }).map(region -> WeightedEntry.m_146290_((Object)region, (int)region.getWeight())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public int apply(AreaContext context, int x, int y) {
        Optional<WeightedEntry.Wrapper<Region>> entry = this.weightedEntries.getRandom(context);
        return entry.isPresent() ? Regions.getIndex(this.regionType, ((Region)entry.get().m_146310_()).getName()) : 0;
    }

    private static class WeightedRandomList<E extends WeightedEntry> {
        private final int totalWeight;
        private final ImmutableList<E> items;

        WeightedRandomList(List<? extends E> items) {
            this.items = ImmutableList.copyOf(items);
            this.totalWeight = WeightedRandom.m_146312_(items);
        }

        public static <E extends WeightedEntry> WeightedRandomList<E> create() {
            return new WeightedRandomList<E>(ImmutableList.of());
        }

        @SafeVarargs
        public static <E extends WeightedEntry> WeightedRandomList<E> create(E ... entries) {
            return new WeightedRandomList<E>(ImmutableList.copyOf((Object[])entries));
        }

        public static <E extends WeightedEntry> WeightedRandomList<E> create(List<E> entries) {
            return new WeightedRandomList<E>(entries);
        }

        public Optional<E> getRandom(AreaContext context) {
            if (this.totalWeight == 0) {
                return Optional.empty();
            }
            int i = context.nextRandom(this.totalWeight);
            return WeightedRandom.m_146314_(this.items, (int)i);
        }
    }
}

