/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class LabelHolder {
    private final Map<String, List<BlockPos>> LABELS = new HashMap<String, List<BlockPos>>();

    private LabelHolder() {
    }

    public static LabelHolder empty() {
        return new LabelHolder();
    }

    public static LabelHolder from(ItemStack stack) {
        LabelHolder labels = LabelHolder.empty();
        CompoundTag tag = stack.m_41784_().m_128469_("sfm:labels");
        for (String label : tag.m_128431_()) {
            labels.addAll(label, tag.m_128437_(label, 4).stream().map(LongTag.class::cast).mapToLong(LongTag::m_7046_).mapToObj(BlockPos::m_122022_).collect(Collectors.toList()));
            labels.addAll(label, tag.m_128437_(label, 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toList()));
        }
        return labels;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (String label : this.get().keySet()) {
            ListTag list = new ListTag();
            list.addAll(this.LABELS.get(label).stream().map(NbtUtils::m_129224_).toList());
            tag.m_128365_(label, (Tag)list);
        }
        return tag;
    }

    public Stream<BlockPos> getPositions(LabelAccess access) {
        return access.labels().stream().map(Label::name).map(this::getPositions).flatMap(Collection::stream);
    }

    public boolean contains(String label, BlockPos pos) {
        return this.LABELS.getOrDefault(label, Collections.emptyList()).contains(pos);
    }

    public LabelHolder toggle(String label, BlockPos pos) {
        if (this.contains(label, pos)) {
            this.remove(label, pos);
        } else {
            this.add(label, pos);
        }
        return this;
    }

    public Map<String, List<BlockPos>> get() {
        return this.LABELS;
    }

    public List<BlockPos> getPositions(String label) {
        return this.LABELS.computeIfAbsent(label, s -> new ArrayList());
    }

    public LabelHolder addAll(String label, List<BlockPos> positions) {
        this.getPositions(label).addAll(positions);
        return this;
    }

    public LabelHolder addReferencedLabel(String label) {
        this.getPositions(label);
        return this;
    }

    public List<Component> asHoverText() {
        ArrayList<Component> rtn = new ArrayList<Component>();
        if (this.LABELS.isEmpty()) {
            return rtn;
        }
        rtn.add((Component)Constants.LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL_HEADER.getComponent().m_130940_(ChatFormatting.UNDERLINE));
        for (Map.Entry<String, List<BlockPos>> entry : this.LABELS.entrySet()) {
            rtn.add((Component)Constants.LocalizationKeys.DISK_ITEM_TOOLTIP_LABEL.getComponent(entry.getKey(), entry.getValue().size()).m_130940_(ChatFormatting.GRAY));
        }
        return rtn;
    }

    public LabelHolder remove(BlockPos value) {
        this.LABELS.values().forEach((? super T list) -> list.remove(value));
        return this;
    }

    public LabelHolder prune() {
        this.LABELS.entrySet().removeIf((? super E entry) -> ((List)entry.getValue()).isEmpty());
        return this;
    }

    public LabelHolder clear() {
        this.LABELS.clear();
        return this;
    }

    public LabelHolder add(String label, BlockPos position) {
        this.getPositions(label).add(position);
        return this;
    }

    public LabelHolder remove(String label, BlockPos pos) {
        this.getPositions(label).remove(pos);
        return this;
    }

    public LabelHolder save(ItemStack stack) {
        stack.m_41784_().m_128365_("sfm:labels", (Tag)this.serialize());
        return this;
    }

    public LabelHolder removeIf(BiPredicate<String, BlockPos> predicate) {
        this.LABELS.forEach((? super K key, ? super V value) -> value.removeIf((? super E pos) -> predicate.test((String)key, (BlockPos)pos)));
        return this;
    }

    public LabelHolder removeIf(Predicate<String> predicate) {
        this.LABELS.keySet().removeIf(predicate);
        return this;
    }

    public LabelHolder forEach(BiConsumer<String, BlockPos> consumer) {
        this.LABELS.forEach((? super K key, ? super V value) -> value.forEach((? super T pos) -> consumer.accept((String)key, (BlockPos)pos)));
        return this;
    }
}

