/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CableNetworkManager {
    private static final Map<Level, List<CableNetwork>> NETWORKS = new WeakHashMap<Level, List<CableNetwork>>();

    public static void unregister(Level level, BlockPos cablePos) {
        CableNetworkManager.getNetwork(level, cablePos).ifPresent(network -> {
            CableNetworkManager.removeNetwork(network);
            List<CableNetwork> newNetworks = network.withoutCable(cablePos);
            newNetworks.forEach(CableNetworkManager::addNetwork);
        });
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(BlockEntity tile) {
        return CableNetworkManager.getOrRegisterNetwork(tile.m_58904_(), tile.m_58899_());
    }

    private static Optional<CableNetwork> getNetwork(Level level, BlockPos pos) {
        return NETWORKS.getOrDefault(level, Collections.emptyList()).stream().filter(net -> net.getLevel().m_5776_() == level.m_5776_()).filter(net -> net.containsCableLocation(pos)).findFirst();
    }

    private static void removeNetwork(CableNetwork network) {
        NETWORKS.getOrDefault(network.getLevel(), Collections.emptyList()).remove(network);
    }

    private static void addNetwork(CableNetwork network) {
        NETWORKS.computeIfAbsent(network.getLevel(), k -> new ArrayList()).add(network);
    }

    private static Set<CableNetwork> getCandidateNetworks(Level level, BlockPos pos) {
        return NETWORKS.getOrDefault(level, Collections.emptyList()).stream().filter(net -> net.getLevel().m_5776_() == level.f_46443_).filter(net -> net.hasCableNeighbour(pos)).collect(Collectors.toSet());
    }

    private static Optional<CableNetwork> createAndRegisterNetwork(Level level, BlockPos origin) {
        CableNetwork network = new CableNetwork(level);
        CableNetworkManager.addNetwork(network);
        network.rebuildNetwork(origin);
        return Optional.of(network);
    }

    private static Optional<CableNetwork> mergeNetworks(Set<CableNetwork> networks) {
        if (networks.isEmpty()) {
            return Optional.empty();
        }
        Iterator<CableNetwork> iterator = networks.iterator();
        CableNetwork main = iterator.next();
        iterator.forEachRemaining(other -> {
            main.mergeNetwork((CableNetwork)other);
            CableNetworkManager.removeNetwork(other);
        });
        return Optional.of(main);
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(@Nullable Level level, BlockPos pos) {
        if (level == null) {
            return Optional.empty();
        }
        if (level.m_5776_()) {
            return Optional.empty();
        }
        if (!CableNetwork.isCable(level, pos)) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = CableNetworkManager.getNetwork(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        Set<CableNetwork> candidates = CableNetworkManager.getCandidateNetworks(level, pos);
        if (candidates.isEmpty()) {
            return CableNetworkManager.createAndRegisterNetwork(level, pos);
        }
        if (candidates.size() == 1) {
            CableNetwork network = candidates.iterator().next();
            network.addCable(pos);
            return Optional.of(network);
        }
        Optional<CableNetwork> result = CableNetworkManager.mergeNetworks(candidates);
        result.ifPresent(net -> net.addCable(pos));
        return result;
    }
}

