/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Side;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;

public record DirectionQualifier(EnumSet<Direction> directions) implements ASTNode
{
    public static DirectionQualifier NULL_DIRECTION = new DirectionQualifier(EnumSet.noneOf(Direction.class));
    public static DirectionQualifier EVERY_DIRECTION = new DirectionQualifier(EnumSet.allOf(Direction.class));

    public static Direction lookup(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.TOP -> Direction.UP;
            case Side.BOTTOM -> Direction.DOWN;
            case Side.NORTH -> Direction.NORTH;
            case Side.SOUTH -> Direction.SOUTH;
            case Side.EAST -> Direction.EAST;
            case Side.WEST -> Direction.WEST;
        };
    }

    public static String directionToString(@Nullable Direction direction) {
        if (direction == null) {
            return "";
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> "TOP";
            case Direction.DOWN -> "BOTTOM";
            case Direction.NORTH -> "NORTH";
            case Direction.SOUTH -> "SOUTH";
            case Direction.EAST -> "EAST";
            case Direction.WEST -> "WEST";
        };
    }

    public Stream<Direction> stream() {
        if (this == EVERY_DIRECTION) {
            return Stream.concat(this.directions.stream(), Stream.builder().add(null).build());
        }
        if (this.directions.isEmpty()) {
            return Stream.builder().add(null).build();
        }
        return this.directions.stream();
    }
}

