/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record ServerboundNetworkToolUsePacket(BlockPos blockPosition, Direction blockFace) {
    public static void encode(ServerboundNetworkToolUsePacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130064_(msg.blockPosition);
        friendlyByteBuf.m_130068_((Enum)msg.blockFace);
    }

    public static ServerboundNetworkToolUsePacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundNetworkToolUsePacket(friendlyByteBuf.m_130135_(), (Direction)friendlyByteBuf.m_130066_(Direction.class));
    }

    public static void handle(ServerboundNetworkToolUsePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockPos pos;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_9236_();
            if (!level.m_46749_(pos = msg.blockPosition())) {
                return;
            }
            StringBuilder payload = new StringBuilder().append("---- block position ----\n").append(pos).append("\n---- block state ----\n");
            BlockState state = level.m_8055_(pos);
            payload.append(state).append("\n");
            CableNetworkManager.getNetworkFromPosition((Level)level, pos).ifPresent(net -> {
                payload.append("---- cable network ----\n");
                payload.append(net).append("\n");
            });
            BlockEntity entity = level.m_7702_(pos);
            if (entity != null && !FMLEnvironment.production) {
                payload.append("---- (dev only) block entity ----\n");
                payload.append(entity).append("\n");
            }
            payload.append("---- exports ----\n");
            int len = payload.length();
            SFMResourceTypes.DEFERRED_TYPES.get().getEntries().forEach(arg_0 -> ServerboundNetworkToolUsePacket.lambda$handle$1(payload, (Level)level, pos, msg, arg_0));
            if (payload.length() == len) {
                payload.append("No exports found");
            }
            payload.append("\n");
            if (entity != null && player.m_20310_(2)) {
                payload.append("---- (op only) nbt data ----\n");
                payload.append(entity.serializeNBT()).append("\n");
            }
            SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundInputInspectionResultsPacket(SFMUtils.truncate(payload.toString(), 20480)));
        });
    }

    private static /* synthetic */ void lambda$handle$1(StringBuilder payload, Level level, BlockPos pos, ServerboundNetworkToolUsePacket msg, Map.Entry entry) {
        payload.append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), (LevelAccessor)level, pos, msg.blockFace));
    }
}

